﻿using Sonic.Web.Model;

namespace Sonic.Services
{
    public class WorkContext
    {
        private EchoOperatorModel _currentOperator;
        private OperatorModel _operator;
        private LoginRoleType _loginType;

        public WorkContext(EchoOperatorModel model)
        {
            _currentOperator = model;
            _loginType = LoginRoleType.ECHO;
        }
        public WorkContext(OperatorModel model)
        {
            _operator = model;
            _loginType = LoginRoleType.Sonic;
        }
  
        public LoginRoleType LoginType
        {
            get
            {
                return _loginType;
            }
        }
        public EchoOperatorModel CurrentOperator
        {
            get
            {
                return _currentOperator;
            }
        }
     
        public OperatorModel Operator
        {
            get
            {
                return _operator;
            }
        }
    }
}