﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Sonic.Services;
using Sonic.Services.Controllers;
using Sonic.Web.DAL;
using Sonic.Web.Model;
using Sonic.Web.Model.ApiIntegration.OrderModel;
using Sonic.Web.Service;

namespace Sonic.Service.PL.Controllers.Order
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class EDIOrderController : BaseController
    {
        private readonly OrderService _orderService;
        private readonly IRequestRepository _requestRepository;
        private readonly LoginService loginService;
        public EDIOrderController(IRequestRepository requestRepository) : base(requestRepository)
        {
            _requestRepository = requestRepository;
            _orderService = new OrderService(_requestRepository);
            loginService = new LoginService(_requestRepository, null);
        }

        [HttpPost]
        [ActionName("SaveEDIOrder")]
        public JsonResult PostEDIOrder([FromBody]EDIOrderInputModel EDIOrder)
        {
            GlobalErrors result = GlobalErrors.Success;
            EDIOrderOutputModel orderProcessingResult;
            OperatorModel operatorModel = new OperatorModel();
            string errorMessage = string.Empty;
            try
            {
                result = loginService.SimpleLogin(EDIOrder.Username, EDIOrder.Password, ref operatorModel, ref errorMessage, 1);
                if (result == GlobalErrors.Success)
                {
                    _requestRepository.CurrentOperator = operatorModel;
                    orderProcessingResult = new EDIOrderOutputModel();
                    result = _orderService.PrepareEDIOrder(EDIOrder, ref orderProcessingResult);
                    if (result == GlobalErrors.Success)
                    {
                        return JSonResultResponse.GetSuccessJSon(orderProcessingResult, "Order Placed Successfully");
                    }
                    else
                    {
                        return JSonResultResponse.GetErrorJSon(orderProcessingResult.Message);
                    }
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon("Invalid Username Or Password");
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
    }
}