﻿using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.SignalR;
using Sonic.Services.Controllers;
using Sonic.Web.DAL;
using Sonic.Web.Model;
using Sonic.Web.Resources;
using Sonic.Web.Service;
using System;
using System.Collections.Generic;
using System.Reflection;
using System.Threading.Tasks;

namespace Sonic.Services.Controllers.Notification
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    //[Authorize]
    public class Notification : Hub
    {

        public override async Task OnConnectedAsync()
        {
            await base.OnConnectedAsync();
            await Clients.Caller.SendAsync("Message",
              "Successfully connected");
        }

        public override async Task  OnDisconnectedAsync(Exception exception)
        {
            await Clients.Caller.SendAsync("Message",
              "Successfully disconnected");
            await base.OnDisconnectedAsync(exception);
        }

        [HttpGet]
        [ActionName("GetName")]
        public async Task GetName(string TESTName)
        {
            try
            {
                // TODO - add the client to a group of clients interested in getting updates on the question 
                // TODO - send a message to the client to indicate that the subscription was successful
                JSonResultResponse.GetSuccessJSon(TESTName, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, 1));
            }
            catch (Exception)
            {

                throw;
            }

        }

        //[HttpGet]
        //[ActionName("GetName")]
        //public JsonResult GetName(string TESTName)
        //{
        //    try
        //    {
        //        var result = GlobalErrors.Success;

        //        //app.UseRouting();
        //        //app.UseEndpoints(endpoints =>
        //        //{
        //        //    endpoints.MapHub<ChatHub>("/chathub");
        //        //});
        //        //IHubContext hubContext = GlobalHost.ConnectionManager.GetHubContext<EmployeeKeyHub>();
        //        //hubContext.Clients.All.ReceiveEmployeeKey(message);
        //        ////save message in [EmployeeKeyNotification] table
        //        //if (ServicesHelperClass.OpenCoreDatabase())
        //        //    result = EmployeeManager.SaveEmployeeKeyNotification(message);






        //        return JSonResultResponse.GetSuccessJSon(TESTName,ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, 1));

        //        if (result == GlobalErrors.Success)
        //        {
        //            return JSonResultResponse.GetSuccessJSon( ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, 1));
        //        }
        //        else if (result == GlobalErrors.NoMoreRows)
        //        {
        //            return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_No_Data_Found, 1));
        //        }
        //        else
        //        {
        //            return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, 1));
        //        }
        //    }
        //    catch (Exception ex)
        //    {
        //        ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
        //        return JSonResultResponse.GetErrorJSon();
        //    }
        //}
    }
}
