﻿using Microsoft.AspNetCore.Hosting;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Microsoft.IdentityModel.Tokens;
using Newtonsoft.Json;
using Sonic.Web.Core;
using Sonic.Web.DAL;
using Sonic.Web.Model;
using Sonic.Web.Resources;
using Sonic.Web.Service;
using System;
using System.Collections.Generic;
using System.IdentityModel.Tokens.Jwt;
using System.Net.NetworkInformation;
using System.Reflection;
using System.Security.Claims;
using System.Text;

namespace Sonic.Services.Controllers.Login
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class LoginController : ControllerBase
    {
        //private readonly ILicensing _licensing;
        private readonly LoginService _loginService;
        private readonly LoginManager _loginManager;
        private readonly IRequestRepository _requestRepository;

        public LoginController(IRequestRepository requestRepository)
        {
            //_licensing = licensing;
            _requestRepository = requestRepository;
            _loginService = new LoginService(requestRepository, null);
            _loginManager = new LoginManager(requestRepository);
        }

        private string GenerateToken(LoggedInUserModel LoginData)
        {
            try
            {
                string securityKey = LocalUtilities.UsedSecurityKey;
                //symmetric security key
                var symmetricSecurityKey = new SymmetricSecurityKey(Encoding.UTF8.GetBytes(securityKey));

                //signing credentials
                var signingCredentials = new SigningCredentials(symmetricSecurityKey, SecurityAlgorithms.HmacSha256Signature);

                //add claims
                var claims = new List<Claim>();
                claims.Add(new Claim(ClaimTypes.Name, JsonConvert.SerializeObject(LoginData)));
                claims.Add(new Claim(ClaimTypes.Role, LoginRoleType.Sonic.GetHashCode().ToString())); 
                //create token
                var token = new JwtSecurityToken(
                        issuer: LocalUtilities.UsedIssuer,
                        audience: LocalUtilities.UsedAudience,
                        expires: DateTime.Now.AddHours(LocalUtilities.UsedTimeout),
                        signingCredentials: signingCredentials,
                        claims: claims
                    );
                return new JwtSecurityTokenHandler().WriteToken(token);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return string.Empty;
            }
        }

        [HttpPost]
        [ActionName("APILogin")]
        public JsonResult APILogin([FromBody] LoginDataModel LoginData)
        {
            string errorMessage = string.Empty;
            int languageId = 1;
            //string password = string.Empty;
            try
            {
                if (!ModelState.IsValid)
                {
                    return JSonResultResponse.GetErrorJSon("Error");
                }
                
                OperatorModel operatorModel = new OperatorModel();
                CachedGeneralData generalData = new CachedGeneralData();
                GlobalErrors result = _loginService.SimpleLogin(LoginData.Username, LoginData.Password, ref operatorModel, ref errorMessage, languageId);
                if (result == GlobalErrors.Success && operatorModel != null)
                {
                    if (result != GlobalErrors.Success)
                    {
                        return JSonResultResponse.GetErrorJSon("Error");
                    }
                    LoggedInUserModel model = new LoggedInUserModel();
                    model.UserId = operatorModel.EmployeeId.ToString();
                    model.SiteCode = LoginData.SiteCode;
                    string tokenString = GenerateToken(model);

                    if (string.IsNullOrEmpty(tokenString.Trim()))
                    {
                        return JSonResultResponse.GetErrorJSon("Error Generating Key");
                    }

                    var data = new
                    {
                        token = tokenString,
                    };
                    return JSonResultResponse.GetSuccessJSon(data, "Success");
                }
                else if (result == GlobalErrors.PasswordShouldBeChanged && operatorModel != null)
                {
                    return JSonResultResponse.GetSuccessJSon(result, ResourcesManager.TranslateKey(errorMessage, languageId));
                }
                else
                {
                    if (string.IsNullOrEmpty(errorMessage))
                        errorMessage = "Invalid Username Or Password";
                    return JSonResultResponse.GetErrorJSon(errorMessage);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
    }
}
