﻿using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using Sonic.Web.DAL;
using Sonic.Web.Model;
using Sonic.Web.Resources;
using Sonic.Web.Service;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using System.Threading.Tasks;

namespace Sonic.Services.Controllers.Location
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    [Authorize]
    public class LocationController : BaseController
    {
        private readonly IRequestRepository _requestRepository;
        private readonly LocationService _locationService;
        public LocationController(IRequestRepository requestRepository) : base(requestRepository)
        {
            _requestRepository = requestRepository;
            _locationService = new LocationService(requestRepository);
        }
        [HttpGet]
        [ActionName("GetCountries")]
        public JsonResult GetCountries()
        {
            try
            {
                List<Country> CountryList = new List<Country>();
                GlobalErrors result = _locationService.GetCountries(ref CountryList);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessJSon(CountryList, "Success");
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon("Error");
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpGet]
        [ActionName("GetStates")]
        public JsonResult GetStates(int countryId)
        {
            try
            {
                var statList = new List<State>();
                GlobalErrors result = _locationService.GetStates(countryId, ref statList);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessJSon(statList, "Success");
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon("Error");
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [ActionName("GetCities")]
        public JsonResult GetCities(int countryId, int stateId)
        {
            try
            {
                var cityList = new List<City>();
                GlobalErrors result = _locationService.GetCities(countryId, stateId, ref cityList);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessJSon(cityList, "Success");
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon("Error");
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }


        [ActionName("GetAreas")]
        public JsonResult GetAreas(int cityId)
        {
            try
            {
                var areaList = new List<Area>();
                GlobalErrors result = _locationService.GetAreas(cityId, ref areaList);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessJSon(areaList, "Success");
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon("Error");
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
    }
}
