﻿using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using Sonic.Web.DAL;
using Sonic.Web.Model;
using Sonic.Web.Resources;
using Sonic.Web.Service;
using System;
using System.Collections.Generic;
using System.Reflection;

namespace Sonic.Services.Controllers.ICash
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    [Authorize]
    public class ICashController : BaseController
    {
        private readonly CustomerService _customerService;
        private readonly IRequestRepository _requestRepository;
        public ICashController(IRequestRepository requestRepository) : base(requestRepository)
        {
            _requestRepository = requestRepository;
            _customerService = new CustomerService(_requestRepository);
        }

      

    
      
    }
}
