﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Sonic.Services;
using Sonic.Services.Controllers;
using Sonic.Web.DAL;
using Sonic.Web.Model;
using Sonic.Web.Resources;
using Sonic.Web.Service;

namespace Sonic.Service.PL.Controllers.Echo
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class ExternalNotificationsController : ControllerBase
    {
        public ExternalNotificationsController()
        {
        }

        [HttpPost]
        [ActionName("SendUpdateOrderNotification")] // To Customer App
        public int SendUpdateOrderNotification([FromBody] ExternalOrderModel order)
        {

            GlobalErrors result = GlobalErrors.Success;
            try
            {
                result = ExternalNotificationsService.SendUpdateOrderNotification(order);
                if (result == GlobalErrors.Success)
                {
                    return GlobalErrors.Success.GetHashCode();
                }
                else
                {
                    return GlobalErrors.Error.GetHashCode();
                }
            }
            catch (Exception)
            {
                return GlobalErrors.Error.GetHashCode();
            }
        }        
    }
}