﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.IO;
using System.Linq;
using System.Reflection;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Hosting;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Sonic.Services;
using Sonic.Services.Controllers;
using Sonic.Web.DAL;
using Sonic.Web.Model;
using Sonic.Web.Resources;
using Sonic.Web.Service.Survey;

namespace Sonic.Service.PL.Controllers.Echo
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    [Authorize]
    public class EchoSurveyController : BaseController
    {
        private readonly SurveyService _service;
        private readonly IRequestRepository _requestRepository;
        private IHostingEnvironment _hostingEnvironment;

        public EchoSurveyController(IHostingEnvironment hostingEnvironment, IRequestRepository requestRepository) : base(requestRepository)
        {
            _requestRepository = requestRepository;
            _hostingEnvironment = hostingEnvironment;
            _service = new SurveyService(_requestRepository, hostingEnvironment, null);
        }
        [HttpGet]
        [ActionName("GetCustomerSurveyList")]
        public JsonResult GetCustomerSurveyList()
        {
            GlobalErrors result = GlobalErrors.Success;
            try
            {
                List<SurveyModel> surevyList = new List<SurveyModel>();
                result = _service.GetCustomerSurveys(ref surevyList);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessJSon(surevyList, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception)
            {
                return JSonResultResponse.GetErrorJSon();
            }
        }
        [HttpGet]
        [ActionName("GetCustomerSurveyAfterSaveOrder")]
        public JsonResult GetCustomerSurveyAfterSaveOrder()
        {
            GlobalErrors result = GlobalErrors.Success;
            try
            {
                SurveyModel surevy = new SurveyModel();
                List<QuestionModel> questionModels = new List<QuestionModel>();
                List<LOVModel> optionModels = new List<LOVModel>();
                result = _service.GetCustomerSurveyAfterSaveOrder(ref surevy, ref questionModels, ref optionModels);
                if (result == GlobalErrors.Success)
                {
                    if (surevy.SurveyId == -1)
                    {
                        return JSonResultResponse.GetSuccessJSon(null, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                    }

                    var data = new
                    {
                        surevy = surevy,
                        questions = questionModels,
                        options = optionModels
                    };


                    return JSonResultResponse.GetSuccessJSon(data, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception)
            {
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpGet]
        [ActionName("GetSurveyQuestions")]
        public JsonResult GetSurveyQuestions(int surveyId)
        {
            GlobalErrors result = GlobalErrors.Success;
            try
            {
                List<QuestionModel> questionModels = new List<QuestionModel>();
                List<LOVModel> optionModels = new List<LOVModel>();
                result = _service.GetCustomerSurveyQuestions(surveyId,ref questionModels,ref optionModels);
                if (result == GlobalErrors.Success)
                {
                    var data = new
                    {
                        questions = questionModels,
                        options = optionModels
                    };
                    return JSonResultResponse.GetSuccessJSon(data, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception)
            {
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("SaveSurveyAnswers")]
        public JsonResult SaveSurveyAnswers([FromBody] List<AnswerModel> surveyAnswers)
        {
            try
            {
                if (!ModelState.IsValid)
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
                var result = _service.SaveSurveyAnswers(surveyAnswers, _hostingEnvironment.ContentRootPath);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessJSon(string.Empty);
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        [HttpPost]
        [ActionName("UploadAnswersImages")]
        public JsonResult UploadAnswersImages([FromForm] Collection<IFormFile> image)
        {
            try
            {
                if (!ModelState.IsValid)
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Provide_UserName_Password, _requestRepository.LanguageId));
                }
                byte[] buff = null;
                byte[] bannerImage = new byte[16 * 1024];
                string rootPath = _hostingEnvironment.ContentRootPath;
                string echoFolderName = "Echo";
                string echoPath = Path.Combine(rootPath, "wwwroot", echoFolderName);
                if (!Directory.Exists(echoPath))
                {
                    Directory.CreateDirectory(echoPath);
                }

                for (int i = 0; i < Request.Form.Files.Count(); i++)
                {
                    string fileName = Request.Form.Files[i].FileName;
                    string[] path = fileName.Split('_');
                    string surveyId = path[0];
                    string questionId = path[1];
                    string custOut = _requestRepository.CurrentEchoOperator.CustomerId + "_" + _requestRepository.CurrentEchoOperator.OutletId;
                    string surveyFolderName = "Echo\\Surveys\\" + surveyId + "\\" + custOut + "\\" + questionId;
                    string surveyPath = Path.Combine(rootPath, "wwwroot", surveyFolderName);
                    if (!Directory.Exists(surveyPath))
                    {
                        Directory.CreateDirectory(surveyPath);
                    }
                    var file = Request.Form.Files[i];
                    if (file.Length > 0)
                    {
                        string fullPath = Path.Combine(surveyPath, fileName);
                        using (var stream = new FileStream(fullPath, FileMode.Create))
                        {
                            file.CopyTo(stream);
                        }
                        buff = System.IO.File.ReadAllBytes(fullPath);
                    }
                }
                return JSonResultResponse.GetSuccessJSon(string.Empty);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }



        [HttpPost]
        [ActionName("UploadAnswersImagesNew")]
        public string UploadAnswersImagesNew([FromBody] EchoOperatorLoginModel operatorData)
        {
            try
            {
              if(operatorData.UserName != null)
                {
                    ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, "found", null, null, 0);
                    return operatorData.UserName;
                }
                else
                {
                    ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, "not found", null, null, 0);
                    return "not found";
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, "error", null, null, 0);
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return "error";
            }
        }
    }
}