﻿using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.Mvc.Filters;
using Sonic.Web.DAL;
using Sonic.Web.Model;
using System;

namespace Sonic.Services.Controllers
{
    public class BaseController : Controller
    {
        private readonly IRequestRepository _requestRepository;

        public BaseController(IRequestRepository requestRepository)
        {
            _requestRepository = requestRepository;
        }

        public override void OnActionExecuting(ActionExecutingContext filerContext)
        {
            try
            {
                var languageId = this.Request.Headers["LanguageId"].ToString();
                if (!string.IsNullOrEmpty(languageId))
                {
                    _requestRepository.LanguageId = Int32.Parse(languageId);
                }
                if (this.WorkContext() != null) // in registration
                {
                    switch (this.WorkContext().LoginType)
                    {
                        case LoginRoleType.ECHO:
                            _requestRepository.CurrentEchoOperator = this.WorkContext().CurrentOperator;
                            if (_requestRepository.CurrentEchoOperator == null)
                            {
                                _requestRepository.CurrentEchoOperator = new Web.Model.EchoOperatorModel();
                                _requestRepository.CurrentEchoOperator.RouteEmployeeId = 0;
                                _requestRepository.CurrentEchoOperator.RouteOperatorId = 0;
                                _requestRepository.CurrentEchoOperator.RouteOrganizationId = 1;
                            }
                            _requestRepository.CurrentOperator = new Web.Model.OperatorModel();
                            _requestRepository.CurrentOperator.EmployeeId = _requestRepository.CurrentEchoOperator.RouteEmployeeId;
                            _requestRepository.CurrentOperator.OperatorId = _requestRepository.CurrentEchoOperator.RouteOperatorId;
                            _requestRepository.CurrentOperator.OrganizationId = _requestRepository.CurrentEchoOperator.RouteOrganizationId;
                            break;


                        default:
                            _requestRepository.CurrentOperator = this.WorkContext().Operator;
                            break;
                    }
                }
            }
            catch (Exception ex)
            {
            }
        }
    }
}