import 'package:echo_app/shared/core.session.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';

// ignore: must_be_immutable
class TotalBox extends StatelessWidget {
  double netTotal = 0;
  TotalBox(this.netTotal);

  @override
  Widget build(BuildContext context) {
    return Container(
      decoration: BoxDecoration(
        border: Border(
          top: BorderSide(color: Colors.grey, width: 1),
        ),
      ),
      child: Row(
          mainAxisAlignment: MainAxisAlignment.center,
          crossAxisAlignment: CrossAxisAlignment.center,
          children: <Widget>[
            Text(
              "total".tr +
                  ": " +
                  this
                      .netTotal
                      .toStringAsFixed(CoreSession.numberOfDigits)
                      .toString() +
                  " " +
                  CoreSession.currentOperator['currencyCode'],
              style: TextStyle(
                  fontSize: 20,
                  color: Colors.black,
                  decoration: TextDecoration.none),
            ),
          ]),
    );
  }
}
