import 'package:flutter/material.dart';
import 'package:get/get.dart';

import '../theme/variables.dart';

// ignore: must_be_immutable
class TextFieldWidget extends StatelessWidget {
  TextEditingController controller;
  String labelText;
  IconData? icon;
  var constPadding = EdgeInsets.all(0);
  bool enabled = true;
  // ignore: avoid_init_to_null
  TextFieldWidget(this.enabled,this.constPadding, this.controller, this.labelText, [this.icon = null]);

  @override
  Widget build(BuildContext context) {
    var _textStyle = TextStyle(color: Variables.color_primary);
    var _underlineInputBorder = UnderlineInputBorder(
      borderSide: BorderSide(color: Variables.color_primary),
    );
    return Container(
      padding: constPadding,
      child: TextField(
        enabled: this.enabled,
        controller: controller,
        decoration: this.icon != null
            ? InputDecoration(
                prefixIcon: Icon(
                  this.icon,
                  color: Variables.color_primary,
                ),
                labelStyle: _textStyle,
                enabledBorder: _underlineInputBorder,
                focusedBorder: _underlineInputBorder,
                labelText: labelText.tr,
              )
            : InputDecoration(
                labelStyle: _textStyle,
                enabledBorder: _underlineInputBorder,
                focusedBorder: _underlineInputBorder,
                labelText: labelText.tr,
              ),
      ),
    );
  }
}
