import 'package:echo_app/theme/variables.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:searchfield/searchfield.dart';

import '../screens/item-informations-page/item-informations.page.dart';
import '../services/items.service.dart';

// ignore: must_be_immutable
class Search_Bar extends StatelessWidget {
  TextEditingController _searchCtrl;
  Function onEnterSearch;
  bool Enabled;
  List items =[];

  Search_Bar.CustomSearchBar(this._searchCtrl, this.onEnterSearch , this.Enabled){
    this.items.addAll(ItemService.items);
  }
  @override
  Widget build(BuildContext context) {
    return Container(
      padding: EdgeInsets.symmetric(horizontal: 10, vertical: 0),
      height: 55,
      child: Column(
        children: [
          InkWell(
            child: SearchField<dynamic>(
              enabled: Enabled ,
              controller:_searchCtrl,
              searchStyle: TextStyle(color: Colors.black,fontSize: 13),
              hint: 'type-to-search'.tr,
              autofocus: true,
              searchInputDecoration: InputDecoration(
                focusedBorder: OutlineInputBorder(
                  borderSide: BorderSide(
                    color: Colors.white.withOpacity(0.8),
                  ),
                ),
                border: OutlineInputBorder(
                  gapPadding: 0,
                  borderSide: BorderSide(color: Colors.red),
                ),
              ),
              onSuggestionTap: (item){
                Navigator.of(context).push(MaterialPageRoute(builder: (context) =>ItemInformationsPage(item.item)));
              },
              onSearchTextChanged: (val){
                (context as Element).markNeedsBuild();
              },
              suggestions: _searchCtrl.text.isNotEmpty ? items
                  .where((item) => item['itemName'].toString().toUpperCase()
                  .contains(_searchCtrl.text.toUpperCase()))
                  .map(
                    (e) => SearchFieldListItem<dynamic>(
                  e['itemName'],
                  item: e,
                  // Use child to show Custom Widgets in the suggestions
                  // defaults to Text widget
                  child: Padding(
                    padding: const EdgeInsets.all(8.0),
                    child: Row(
                      children: [
                        Expanded(flex:3,child: Text(e['itemName'])),
                        SizedBox(width: 5,),
                        Expanded(flex:1,child: Text(e['uom'])),
                      ],
                    ),
                  ),
                ),
              ).toList() : [],
            ),
          ),
          // TextFormField(
          //   enabled: Enabled ,
          //   autofocus: true,
          //   style: TextStyle(color: Colors.white),
          //   controller: _searchCtrl,
          //   textAlignVertical: TextAlignVertical.center,
          //   decoration: InputDecoration(
          //       contentPadding: EdgeInsets.zero,
          //     fillColor: Variables.color_secondary.withOpacity(0.1),
          //     filled: true,
          //     border: OutlineInputBorder(
          //       borderSide: const BorderSide(color: Colors.transparent, width: 0.0),
          //       borderRadius: BorderRadius.circular(10.0),
          //     ),
          //     suffixIcon: _searchCtrl.text.isNotEmpty ? IconButton(
          //       icon: Icon(
          //         Icons.close,
          //         color: Colors.white,
          //       ), onPressed: () {
          //       _searchCtrl.text = '';
          //       this.onEnterSearch();
          //     },
          //     ) : null,
          //     prefixIcon: IconButton(
          //       icon: Icon(
          //         Icons.search,
          //         color: Colors.white,
          //       ),
          //       onPressed: () {
          //         this.onEnterSearch();
          //       },
          //     ),
          //     // prefixIcon
          //     hintText: "type-to-search".tr,
          //     hintStyle: TextStyle(color: Colors.white,fontFamily: 'cario'),
          //   ),
          //   // onChanged: (value) {},
          //   onFieldSubmitted: (_) {
          //     this.onEnterSearch();
          //   },
          // ),
        ],
      ),
    );
  }
}
