import 'package:echo_app/widgets/order_summery_and_edit_dialog/add_note_and_delivery.dart';
import 'package:echo_app/widgets/order_summery_and_edit_dialog/order_summery.dart';
import 'package:flutter/material.dart';
import 'package:intl/intl.dart';

// ignore: must_be_immutable
class OrderSummeryAndEditDialog extends StatelessWidget {
  bool showSummery = false;
  bool showAddEditForm = false;
  var summary = [];
  var summeryObj = {};
  Function getEditableData;
  String orderNote;
  bool isViewMode;
  DateTime deliveryDate = new DateTime(
      DateTime.now().year, DateTime.now().month, DateTime.now().day);
  OrderSummeryAndEditDialog(this.showSummery, this.showAddEditForm,
      this.summary, this.orderNote, this.getEditableData, this.deliveryDate, this.isViewMode) {
    if (DateFormat('EEEE').format(deliveryDate).toString() == 'Friday') {
      deliveryDate = new DateTime(
          deliveryDate.year, deliveryDate.month, deliveryDate.day + 1);
    }
  }

  getData(DateTime deliveryDate, String orderNote) {
    this.orderNote = orderNote;
    // ignore: unnecessary_null_comparison
    if (deliveryDate != null) {
      this.deliveryDate = deliveryDate;
    }

    this.getEditableData(this.deliveryDate, this.orderNote);
  }

  @override
  Widget build(BuildContext context) {
    return Column(
      children: <Widget>[
        if (this.showSummery) OrderSummery(this.summary),
        if (this.showSummery && this.showAddEditForm)
          Divider(color: Colors.black),
        if (this.showAddEditForm)
          AddNoteAndDelivery(this.orderNote, this.getData, this.deliveryDate, this.isViewMode),
      ],
    );
  }
}
