import 'package:echo_app/shared/core.session.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';

// ignore: must_be_immutable
class OrderSummery extends StatelessWidget {
  var summary;
  var summeryObj;
  double calculatedDiscountTotalBeforFirstUserDiscount = 0.0;
  double sumDiscount = 0.0;
  double grossTotal = 0.0;
  double netTotal = 0.0;
  double sumTax = 0.0;
  String currencyCode = CoreSession.currentOperator['currencyCode'];
  OrderSummery(this.summary) {
    this.summeryObj = this.summary[0];
    this.calculatedDiscountTotalBeforFirstUserDiscount = double.parse(this
        .summeryObj['calculatedDiscountTotalBeforFirstUserDiscount']
        .toString());
    this.sumDiscount =
        double.parse(this.summeryObj['calculatedTotalDiscount'].toString());
    this.grossTotal = double.parse(this.summeryObj['grossTotal'].toString());
    this.netTotal = double.parse(this.summeryObj['netTotal'].toString());
    this.sumTax =
        double.parse(this.summeryObj['calculatedTotalTax'].toString());
  }

  @override
  Widget build(BuildContext context) {
    return SafeArea(
      child: Container(
        padding: EdgeInsets.only(bottom: 5),
        child: Column(
          children: <Widget>[
            Row(
              mainAxisAlignment: MainAxisAlignment.spaceBetween,
              children: [
                Column(children: [
                  Text("gross".tr + ": ", style: TextStyle(fontSize: 15))
                ]),
                Column(children: [
                  Text(
                      this
                              .grossTotal
                              .toStringAsFixed(CoreSession.numberOfDigits)
                              .toString() +
                          " " +
                          this.currencyCode,
                      style: TextStyle(fontSize: 15))
                ]),
              ],
            ),
            Row(
              mainAxisAlignment: MainAxisAlignment.spaceBetween,
              children: [
                Column(children: [
                  Text("total_discount".tr + ": ",
                      style: TextStyle(fontSize: 15))
                ]),
                Column(children: [
                  Text(
                      this
                              .sumDiscount
                              .toStringAsFixed(CoreSession.numberOfDigits)
                              .toString() +
                          " " +
                          this.currencyCode,
                      style: TextStyle(fontSize: 15))
                ]),
              ],
            ),
            Row(
              mainAxisAlignment: MainAxisAlignment.spaceBetween,
              children: [
                Column(children: [
                  Text("taxTotal".tr + ": ", style: TextStyle(fontSize: 15))
                ]),
                Column(children: [
                  Text(
                      this
                              .sumTax
                              .toStringAsFixed(CoreSession.numberOfDigits)
                              .toString() +
                          " " +
                          this.currencyCode,
                      style: TextStyle(fontSize: 15))
                ]),
              ],
            ),
            Row(
              mainAxisAlignment: MainAxisAlignment.spaceBetween,
              children: [
                Column(children: [
                  Text("net-total".tr + ": ", style: TextStyle(fontSize: 15))
                ]),
                Column(children: [
                  Text(
                      this
                              .netTotal
                              .toStringAsFixed(CoreSession.numberOfDigits)
                              .toString() +
                          " " +
                          this.currencyCode,
                      style: TextStyle(fontSize: 15))
                ]),
              ],
            ),
            if (CoreSession.usedPoints != "")
              Row(
                mainAxisAlignment: MainAxisAlignment.spaceBetween,
                children: [
                  Column(children: [
                    Text("PaiedPointsAmmount".tr + ": ",
                        style: TextStyle(fontSize: 15))
                  ]),
                  Column(children: [
                    Text(
                        CoreSession.pointValue
                                .toStringAsFixed(CoreSession.numberOfDigits)
                                .toString() +
                            " " +
                            this.currencyCode,
                        style: TextStyle(fontSize: 15))
                  ]),
                ],
              ),
            if (CoreSession.usedPoints != "")
              Row(
                mainAxisAlignment: MainAxisAlignment.spaceBetween,
                children: [
                  Column(children: [
                    Text("remaining".tr + ": ", style: TextStyle(fontSize: 15))
                  ]),
                  Column(children: [
                    Text(
                        (this.netTotal - CoreSession.pointValue)
                                .toStringAsFixed(CoreSession.numberOfDigits)
                                .toString() +
                            " " +
                            this.currencyCode,
                        style: TextStyle(fontSize: 15))
                  ]),
                ],
              ),
          ],
        ),
      ),
    );
  }
}
