import 'package:community_material_icon/community_material_icon.dart';
import 'package:echo_app/theme/variables.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:intl/intl.dart';

// ignore: must_be_immutable
class AddNoteAndDelivery extends StatefulWidget {
  DateTime? _selectedDate;
  String orderNote = '';
  Function getData;
  bool isViewMode = false;
  DateTime startDate = new DateTime(
      DateTime.now().year, DateTime.now().month, DateTime.now().day);

  AddNoteAndDelivery(this.orderNote, this.getData, this._selectedDate,this.isViewMode) {
    if (DateFormat('EEEE').format(startDate).toString() == 'Friday') {
      startDate =
          new DateTime(startDate.year, startDate.month, startDate.day + 1);
    }
  }

  @override
  State<AddNoteAndDelivery> createState() => _AddNoteAndDeliveryState();
}

class _AddNoteAndDeliveryState extends State<AddNoteAndDelivery> {
  TextEditingController noteController = new TextEditingController();
  @override
  void initState() {
    noteController.text = widget.orderNote;
    //if(widget._selectedDate != )
    super.initState();
  }

  @override
  Widget build(BuildContext context) {

    void _presentDatePicker() {
      showDatePicker(
        context: context,
        initialDate: widget._selectedDate == null
            ? widget.startDate
            : widget._selectedDate!,
        firstDate: widget.startDate,
        lastDate: new DateTime(3000),
        builder: (context, child) {
          return Theme(
            data: ThemeData.light().copyWith(
              colorScheme: ColorScheme.light().copyWith(
                primary: Variables.color_primary,              ),
            ),
            child: child!,
          );
        },
      ).then(
        (pickedDate) => {
          setState(
            () {
              if (pickedDate != null) {
                widget._selectedDate = pickedDate;
              }
              widget.getData(widget._selectedDate, widget.orderNote);
            },
          ),
        },
      );
    }

    return Container(
      child: Column(
        mainAxisAlignment: MainAxisAlignment.start,
        crossAxisAlignment: CrossAxisAlignment.start,
        children: <Widget>[
          Container(
            padding: EdgeInsets.only(bottom: 10),
            child: Column(
              mainAxisAlignment: MainAxisAlignment.start,
              crossAxisAlignment: CrossAxisAlignment.start,
              children: <Widget>[
                Text(
                  "order-note".tr,
                  style: TextStyle(fontSize: 15),
                ),
                SizedBox(height: 2),
                TextField(
                  minLines: 2,
                  maxLines: 2,
                  enabled: !this.widget.isViewMode,
                  controller: noteController,
                  decoration: new InputDecoration(
                    border: new OutlineInputBorder(
                      borderSide: new BorderSide(color: Colors.teal),
                      borderRadius: BorderRadius.circular(0),
                    ),
                    hintText: '',
                  ),
                  // ignore: non_constant_identifier_names
                  onChanged: (Value) {
                    setState(() {
                      widget.orderNote = Value;
                      widget.getData(widget._selectedDate, widget.orderNote);
                    });
                  },
                ),
              ],
            ),
          ),
          Container(
            padding: EdgeInsets.only(bottom: 5),
            child: Column(
              mainAxisAlignment: MainAxisAlignment.start,
              crossAxisAlignment: CrossAxisAlignment.stretch,
              children: <Widget>[
                Text(
                  "delivery-date".tr,
                  style: TextStyle(fontSize: 15),
                ),
                SizedBox(height: 2),
                Container(
                  padding: EdgeInsets.only(top: 5),
                  child: GestureDetector(
                    onTap: () =>
                    {
                      if(!this.widget.isViewMode)
                        _presentDatePicker(),
                    },
                    child: Row(
                      mainAxisAlignment: MainAxisAlignment.spaceBetween,
                      children: <Widget>[
                        Container(
                          child: Text(
                        widget._selectedDate == null
                            ? 'no-data-found'.tr
                            :  DateFormat('dd/MM/yyyy')
                                .format(widget._selectedDate!)
                                .toString(),
                        style: TextStyle(fontSize: 14),
                      ),
                        ),
                        if(!this.widget.isViewMode)
                        Row(
                          children: [
                            Text(
                              "select".tr,
                              style: TextStyle(
                                  color: Colors.grey,
                                  fontWeight: FontWeight.bold, fontSize: 14),
                            ),
                            Icon(
                              CommunityMaterialIcons.chevron_down,
                              color: Colors.grey,
                              size: 14,
                            )
                          ],
                        )
                      ],
                    ),
                  ),
                ),
               ],
            ),
          ),
        ],
      ),
    );
  }
}
