import 'package:echo_app/services/login.service.dart';
import 'package:echo_app/shared/core.session.dart';
import 'package:echo_app/theme/variables.dart';
import 'package:flutter/material.dart';
import 'package:get/get_utils/src/extensions/internacionalization.dart';

// ignore: must_be_immutable
class LanguagesDropdownWidget extends StatelessWidget {
  LoginService _loginService = new LoginService();
  String lngDesc = '';
  LanguagesDropdownWidget() {
    int languageId = CoreSession.selectedLanguageId;
    lngDesc = CoreSession.languages
        .firstWhere((lang) => lang.languageId == languageId)
        .description;
  }

  @override
  Widget build(BuildContext context) {
    return Container(
      width: MediaQuery.of(context).size.width / 4.5,
      child: DropdownButtonHideUnderline(
        child: DropdownButtonFormField<dynamic>(
          isExpanded: true,
          icon: Image.asset(
              'assets/imgs/more_icons/language.png',
              color: Variables.color_primary,
              height: 33,
              width: 30),
          style: TextStyle(color: Colors.black),
          decoration: InputDecoration(
            enabledBorder: UnderlineInputBorder(
                borderSide: BorderSide
                    .none //BorderSide(color: Variables.color_primary),
                ),
          ),
          onChanged: (val) {
            int languageId = val == null
                ? CoreSession.languages.first.languageId
                : val;
            _loginService.onChangeLanguageBeforeLogin(languageId);
          },
          hint: Text(lngDesc != '' ? lngDesc : "language".tr),
          items: CoreSession.languages.map<DropdownMenuItem>((lang) {
            return DropdownMenuItem(
              value: lang.languageId,
              child: new Text(
                lang.description,
              ),
            );
          }).toList(),
        ),
      ),
    );

    // GestureDetector(
    //   child: Container(
    //     padding: EdgeInsets.fromLTRB(30, 0, 30, 0),

    //     child: Column(
    //       crossAxisAlignment: CrossAxisAlignment.end,
    //       children: [
    //         Text(
    //           "En/عربي",
    //           style: TextStyle(
    //             color: _variables.color_primary,
    //             fontSize: 18,
    //             fontWeight: FontWeight.bold,
    //           ),
    //         ),
    //       ],
    //     ),
    //   ),
    //   onTap: () {
    //     submitData();
    //   },
    // );
  }
}
