import 'package:flutter/material.dart';

import '../theme/variables.dart';

// ignore: must_be_immutable
class GeneralDropdownButtonWidget extends StatefulWidget {
  List list = [];
  var constMargin = EdgeInsets.all(0);
  var dropdownValue;
  String hint;
  String nameString;
  String valueString;
  bool isRequired;
  bool hasError;
  bool fullBordersSide;
  Function? onChangeValue;
  GeneralDropdownButtonWidget(
      this.list,
      this.nameString,
      this.valueString,
      this.constMargin,
      this.dropdownValue,
      this.onChangeValue,
      this.hint,
      this.isRequired,
      this.hasError,
      this.fullBordersSide);

  @override
  State<GeneralDropdownButtonWidget> createState() =>
      _GeneralDropdownButtonWidgetState();
}

class _GeneralDropdownButtonWidgetState
    extends State<GeneralDropdownButtonWidget> {
  @override
  initState() {
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    print(widget.hasError);
    // ignore: unused_local_variable
    var _underlineInputBorder = UnderlineInputBorder(
      borderSide: widget.hasError
          ? BorderSide(color: Colors.redAccent)
          : BorderSide(color: Variables.color_primary),
    );
    // ignore: unused_local_variable
    var _outlineInputBorder = OutlineInputBorder(
      borderSide: widget.hasError
          ? BorderSide(color: Colors.redAccent)
          : BorderSide(color: Variables.color_primary),
    );

    return Container(
      margin: widget.constMargin,
      decoration: BoxDecoration(
        border: Border.all(
            color:
                widget.hasError ? Colors.redAccent : Variables.color_primary),
        borderRadius: BorderRadius.circular(5),
      ),
      padding: EdgeInsets.symmetric(horizontal: 20, vertical: 0),
      child: DropdownButtonHideUnderline(
        child: DropdownButtonFormField<dynamic>(
          isExpanded: true,
          style: TextStyle(color: Colors.black, fontSize: 15),
          decoration: InputDecoration(
            border: InputBorder.none,
          ),
          onChanged: (value) {
            // setState(() {
            //   widget.dropdownValue = value;
            // });
            // widget.dropdownValue = value;
            // if (widget.isRequired) {
            //   setState(() {
            //     if (value == null || value == '') {
            //       widget.hasError = true;
            //     } else {
            //       widget.hasError = false;
            //     }
            //   });
            // }
            if (widget.onChangeValue != null) {
              widget.onChangeValue!(value);
            }
          },
          value: widget.dropdownValue,
          hint: Text(widget.hint),
          items: widget.list.map<DropdownMenuItem>((item) {
            return DropdownMenuItem(
              value: item[widget.valueString.toString()],
              child: Text(item[widget.nameString].toString()),
            );
          }).toList(),
        ),
      ),
    );
  }
}
