import 'package:bottom_bar_matu/utils/app_utils.dart';
import 'package:echo_app/shared/core.session.dart';
import 'package:echo_app/theme/variables.dart';
import 'package:echo_app/widgets/checkOutBottom.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:google_maps_flutter/google_maps_flutter.dart';

// ignore: must_be_immutable
class CheckOutSaveBox extends StatelessWidget {
  double netTotal = 0;
  Function checkOut;

  LatLng ? location;
  String buttonText;

  bool fromSummary ;
  CheckOutSaveBox(this.netTotal, this.checkOut, this.buttonText , this.fromSummary , this.location);

  onClickButton(context , double nettotal , Function checkout) {
    if (nettotal == 0 && CoreSession.usedPoints.isNullOrEmpty()) {
      return;
    }    else
      this.checkOut();
  }

  @override
  Widget build(BuildContext context) {
    return Container(
      child: Row(
        mainAxisAlignment: MainAxisAlignment.spaceBetween,
        crossAxisAlignment: CrossAxisAlignment.stretch,
        children: <Widget>[
          Expanded(
            child: Container(
              child: ElevatedButton(
                onPressed: () => this.onClickButton(context,this.netTotal,this.checkOut),
                child: Row(
                  children: [
                    Spacer(),
                    Text(this.buttonText),
                    Spacer(),
                  ],
                ),
                style: ElevatedButton.styleFrom(
                  backgroundColor: Variables.color_primary,
                  shape: RoundedRectangleBorder(
                    borderRadius: BorderRadius.circular(10),
                  ),
                ),
              ),
            ),
          ),
        ],
      ),
    );
  }
}
