import 'package:community_material_icon/community_material_icon.dart';
import 'package:echo_app/screens/tap_page/tap.page.dart';
import 'package:echo_app/widgets/search_bar.dart';
import 'package:flutter/material.dart';

import '../theme/variables.dart';

class AppBarWidget extends StatefulWidget {
  const AppBarWidget({Key? key}) : super(key: key);

  @override
  _AppBarWidget createState() => _AppBarWidget();
}

class _AppBarWidget extends State<AppBarWidget> {
  TextEditingController _searchCtrl = TextEditingController();
  onEnterSearch() {}
  int counter2 = 20;
  String _title = "Home";
  @override
  Widget build(BuildContext context) {
    return AppBar(
       backgroundColor: Variables.color_primary,
      title: Text(this._title),
      actions: <Widget>[
        Container(
          margin: EdgeInsets.only(top: 5),
          child: new Stack(
            children: <Widget>[
              new IconButton(
                  icon: Icon(CommunityMaterialIcons.cart_outline),
                  onPressed: () {
                    setState(() {
                      // ItemService.cartCount = ItemService.cartCount;
                      // TabPage.cartValue.value = ItemService.cartCount;
                    });
                  }),
              TapPage.cartValue.value != 0
                  ? new Positioned(
                      right: 5,
                      top: 5,
                      child: new Container(
                        padding: EdgeInsets.all(2),
                        decoration: new BoxDecoration(
                          color: Colors.red,
                          borderRadius: BorderRadius.circular(5),
                        ),
                        constraints: BoxConstraints(
                          minWidth: 16,
                          minHeight: 16,
                        ),
                        child: Text(
                          TapPage.cartValue.value.toString(),
                          style: TextStyle(
                            color: Colors.white,
                            fontSize: 9,
                          ),
                          textAlign: TextAlign.center,
                        ),
                      ),
                    )
                  : new Container()
            ],
          ),
        ),
        Container(
          margin: EdgeInsets.only(top: 5),
          child: new Stack(
            children: <Widget>[
              new IconButton(
                  icon: Icon(Icons.notifications_none_outlined),
                  onPressed: () {
                    setState(() {
                      counter2 = 0;
                    });
                  }),
              counter2 != 0
                  ? new Positioned(
                      right: 5,
                      top: 5,
                      child: new Container(
                        padding: EdgeInsets.all(2),
                        decoration: new BoxDecoration(
                          color: Colors.red,
                          borderRadius: BorderRadius.circular(5),
                        ),
                        constraints: BoxConstraints(
                          minWidth: 16,
                          minHeight: 16,
                        ),
                        child: Text(
                          '10',
                          style: TextStyle(
                            color: Colors.white,
                            fontSize: 9,
                          ),
                          textAlign: TextAlign.center,
                        ),
                      ),
                    )
                  : new Container()
            ],
          ),
        ),
        Row(
            //children: [],
            )
      ],
      bottom: PreferredSize(
        preferredSize: Size(50, 50),
        child: Search_Bar.CustomSearchBar(_searchCtrl, this.onEnterSearch,true),
      ),
    );
  }
}
