// ignore_for_file: non_constant_identifier_names

import 'package:echo_app/enums/alert_types.dart';
import 'package:echo_app/theme/variables.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';

// ignore: must_be_immutable
class AlertWidget extends StatelessWidget {
  AlertTypes alertType = AlertTypes.None;
  String text = '';
  Color color_text = Color.fromRGBO(0, 64, 133, 1.0);
  Color color_background = Color.fromRGBO(204, 229, 255, 1.0);
  Color color_border = Color.fromRGBO(184, 218, 255, 1.0);
  AlertWidget(this.alertType, this.text) {
    switch (alertType) {
      case AlertTypes.None:
        break;
      case AlertTypes.Primary:
        this.color_text = Variables.color_primary_alert_text;
        this.color_background = Variables.color_primary_alert_background;
        this.color_border = Variables.color_primary_alert_border;
        break;
      case AlertTypes.Secondary:
        this.color_text = Variables.color_secondary_alert_text;
        this.color_background = Variables.color_secondary_alert_background;
        this.color_border = Variables.color_secondary_alert_border;
        break;
      case AlertTypes.Success:
        this.color_text = Variables.color_success_alert_text;
        this.color_background = Variables.color_success_alert_background;
        this.color_border = Variables.color_success_alert_border;
        break;
      case AlertTypes.Danger:
        this.color_text = Variables.color_danger_alert_text;
        this.color_background = Variables.color_danger_alert_background;
        this.color_border = Variables.color_danger_alert_border;
        break;
      case AlertTypes.Warning:
        this.color_text = Variables.color_warning_alert_text;
        this.color_background = Variables.color_warning_alert_background;
        this.color_border = Variables.color_warning_alert_border;
        break;
      case AlertTypes.Info:
        this.color_text = Variables.color_info_alert_text;
        this.color_background = Variables.color_info_alert_background;
        this.color_border = Variables.color_info_alert_border;
        break;
      case AlertTypes.Light:
        this.color_text = Variables.color_light_alert_text;
        this.color_background = Variables.color_light_alert_background;
        this.color_border = Variables.color_light_alert_border;
        break;
      case AlertTypes.Dark:
        this.color_text = Variables.color_dark_alert_text;
        this.color_background = Variables.color_dark_alert_background;
        this.color_border = Variables.color_dark_alert_border;
        break;
    }
  }
  @override
  Widget build(BuildContext context) {
    return Container(
      width: double.infinity,
      margin: EdgeInsets.symmetric(vertical: 10, horizontal: 10),
      padding: EdgeInsets.symmetric(vertical: 10, horizontal: 10),
      decoration: BoxDecoration(
        border: Border.all(width: 1, color: this.color_border),
        color: this.color_background,
        borderRadius: BorderRadius.circular(5),
      ),
      child: Text(
        "select-vendor-message".tr + ' ...',
        style: TextStyle(color: this.color_text),
      ),
    );
  }
}
