import 'package:community_material_icon/community_material_icon.dart';
import 'package:echo_app/theme/variables.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';

import '../../shared/core.session.dart';

// ignore: must_be_immutable

class MultipleValueSelection {

  static List<String> selectedOptions = [];

  void showMultiRadioButtonDialog(BuildContext context,  Function onClickSave ,List<String> options,_selectedOption, String title) async {
    List<String> result = await showDialog(
      context: context,
      builder: (BuildContext context) {
        return 
        Directionality(
        textDirection: CoreSession.selectedLanguageId == 1 ? TextDirection.ltr : TextDirection.rtl,
        child: 
        AlertDialog(
          title: Text(title.tr),
          content: SingleChildScrollView(
            child: Column(
              children: [
                Column(
                  children: options.map((option) {
                    bool isSelected = selectedOptions.contains(option);
                    return RadioListTile(
                      title: Text(option),
                      value: options.indexOf(option),
                      groupValue: _selectedOption,
                      onChanged: (newValue) {
                        _selectedOption = options.indexOf(option);
                        (context as Element).markNeedsBuild();
                      },
                    );
                  }).toList(),
                ),
              ],
            ),
          ),
          actions: [
            TextButton(
              onPressed: () {
                onClickSave(_selectedOption);
                Navigator.pop(context);
              },
              child: Text('OK'.tr),
            ),
          ],
        ),);
      },
    );

    if (result != null) {
        selectedOptions = result;
        (context as Element).markNeedsBuild();
    }
  }
}
