import 'dart:convert';

import 'package:echo_app/global/global.dart';
import 'package:echo_app/enums/global-errors.dart';
import 'package:http/http.dart' as http;
import 'package:echo_app/shared/core.session.dart';

class OffersService {
  // AuthenticatedHttpClient auth = new AuthenticatedHttpClient();
  var _url = '';
  static bool offersUpdatedSuccesfully = false;
  static var offers = [];
  OffersService() {
    this._url = CoreSession.api + "API/EchoOrder/";
  }

  Future<List<dynamic>> fillOffers() async {
    var offerss = [];
    try {
      final String urlValue = this._url + "GetMyPromotions";

      final res = await http.get(
        Uri.parse(urlValue),
        headers: Global.httpOptions,
      );
      var response = json.decode(res.body);
      if (response['status'] == GlobalErrors.Success.index) {
        var data = response['data'];
        offers = data;
        return data;
      }
      return offerss;
    } catch (error) {
      offerss = [];
      offers = [];
      return offers;
    }
  }
}
