import 'dart:convert';

import 'package:echo_app/global/global.dart';
import 'package:echo_app/models/user.dart';
// import 'package:echo_app/enums/globalErrors.dart';
import 'package:http/http.dart' as http;
import 'package:echo_app/shared/core.session.dart';
// import 'package:firebase_messaging/firebase_messaging.dart';

class NotificationsService {
  var _url = '';
  static var offers = [];
  static bool offersUpdatedSuccesfully = false;
  
  NotificationsService() {
    this._url = CoreSession.api + "API/EchoNotifications/";
  }

  Future<dynamic> getNotificationList() async {
    final String urlValue = this._url + "GetNotificationList";
    try {
      final response = await http.get(
          Uri.parse(urlValue + '?pageNumber=${0}&pageSize=${10000}'),
          headers: Global.httpOptions);
      return json.decode(response.body);
    } catch (error) {
      print(error);
    }
  }

  Future<dynamic> updateDeviceToken(token) async {
    final String urlValue = this._url + 'UpdateDeviceToken';
    UserModel user = new UserModel();
    user.deviceToken = token;
    // var body = jsonEncode(user);
    var body = json.encode({
      'username': user.userName,
      'password': user.password,
      'customerName': user.customerName,
      'phoneNumber': user.phoneNumber,
      'tradeLicenseNumber': user.tradeLicenseNumber,
      'address': user.address,
      'longitude': user.longitude,
      'latitude': user.latitude,
      // 'identification': user.identification,
      'deviceToken': user.deviceToken,
    });
    try {
      final response = await http.post(
        Uri.parse(urlValue),
        headers: Global.httpOptions,
        body: body,
      );
      print('response');
      print(response);
      return json.decode(response.body);
    } catch (error) {
      print(error);
    }
  }
}
