import 'dart:convert';
import 'package:echo_app/models/user.dart';
import 'package:echo_app/shared/core.session.dart';
import 'package:http/http.dart' as http;

class NonOperatorService {
  String _url = "";
  Map<String, String>? _httpOptions;
  NonOperatorService() {
    this._url = CoreSession.api + "API/EchoNonOperator/";
    this._httpOptions = {
      'Content-Type': 'application/json',
      "LanguageId": CoreSession.selectedLanguageId.toString(),
    };
  }

  createAccount(UserModel user) async {
    final String urlValue = this._url + "SaveNewCustomer";
    // var body = json.encode(user);
    var body = json.encode({
      'username': user.userName,
      'password': user.password,
      'customerName': user.customerName,
      'phoneNumber': user.phoneNumber,
      'tradeLicenseNumber': user.tradeLicenseNumber,
      'address': user.address,
      'longitude': user.longitude,
      'latitude': user.latitude,
      // 'identification': user.identification,
      'deviceToken': user.deviceToken,
      'countryId': user.countryId,
      'stateId': user.stateId,
      'cityId': user.cityId,
      'areaId': user.areaId,
      'streetId': user.streetId,
    });
    try {
      final response = await http.post(
        Uri.parse(urlValue),
        headers: _httpOptions,
        body: body,
      );

      return json.decode(response.body);
    } catch (error) {
      print(error);
    }
  }

  Future<String> uploadIdentifications(String filePath, String fileName) async {
    final String urlValue =
        CoreSession.api + "API/EchoCustomer/" + "UploadCustomerIdentification";

    http.MultipartRequest request =
        new http.MultipartRequest("post", Uri.parse(urlValue));

    http.MultipartFile file =
        await http.MultipartFile.fromPath('111|222|' + fileName, filePath);

    request.files.add(file);

    var headers = {"Content-Type": "multipart/form-data"};
    request.headers.addAll(headers);

    var response = await request.send();
    if (response.statusCode == 200) {
      final responseString = await response.stream.bytesToString();
      return responseString;
    } else {
      return "";
    }
  }

  Future<dynamic> getcustomerAppSignUpFields() async {
    final String urlValue = this._url + 'GetCustomerAppSignUpFields';
    try {
      final response =
          await http.get(Uri.parse(urlValue), headers: _httpOptions);
      return json.decode(response.body);
    } catch (error) {
      print(error);
    }
  }

  getLocationHierarchy() async {
    if (CoreSession.locationHierarchyLevel == -1) {
      final String urlValue = this._url +
          "GetLocationHierarchy" +
          "?languageId=${CoreSession.selectedLanguageId}";
      try {
        final response = await http.get(
          Uri.parse(urlValue),
          headers: _httpOptions,
        );
        return json.decode(response.body);
      } catch (error) {
        print(error);
      }
    }
  }

  getEchoGuestOpratorDataAndSettings() async {
    final String urlValue = this._url + "GetEchoGuestOpratorDataAndSettings";
    try {
      final response = await http.get(
        Uri.parse(urlValue),
        headers: _httpOptions,
      );
      return json.decode(response.body);
    } catch (error) {
      print(error);
    }
  }

  getAllLanguages() async {
    final String urlValue = this._url + "GetAllLanguages";
    try {
      final response = await http.get(
        Uri.parse(urlValue),
        headers: _httpOptions,
      );
      return json.decode(response.body);
    } catch (error) {
      print(error);
    }
  }
}
