import 'package:community_material_icon/community_material_icon.dart';
import 'package:echo_app/enums/global-errors.dart';
import 'package:echo_app/screens/surveys/widgets/survey_questions.dart';
import 'package:echo_app/services/survey.service.dart';
import 'package:echo_app/theme/variables.dart';
import 'package:flutter/material.dart';
import 'package:flutter_easyloading/flutter_easyloading.dart';
import 'package:get/get.dart';

// ignore: must_be_immutable
class SurveyListItem extends StatelessWidget {
  var survey;
  var _surveyService = new SurveyService();
  var question = [];
  var questionOptions = [];
  Function populateSurveysList;
  SurveyListItem(this.survey, this.populateSurveysList);
  populateQuestions(int id) async {
    EasyLoading.show(status: 'loading'.tr);
    var response = await _surveyService.getSurveyQuestions(id);
    EasyLoading.dismiss();
    // setState(() {
    if (response['status'] == GlobalErrors.Success.index) {
      if (response['data'] != null) {
        this.question = response['data']['questions'];
        survey['questions'] = [];
        survey['questions'] = this.question;
        this.questionOptions = response['data']['options'];
      } else {
        this.questionOptions = [];
      }
    }
    // });
  }

  @override
  Widget build(BuildContext context) {
    return GestureDetector(
      child: Card(
        elevation: 3,
        shape: RoundedRectangleBorder(
          borderRadius: BorderRadius.circular(3),
        ),
        child: Container(
          padding: EdgeInsets.all(8),
          child: Row(
            children: [
              Expanded(
                  flex: 1,
                  child: Icon(
                    CommunityMaterialIcons.book_edit,
                    color: Colors.green,
                    size: 24,
                  )),
              Expanded(
                flex: 5,
                child: Text(this.survey['surveyName'],
                    style: TextStyle(
                      fontSize: Variables.headline2FontSize,
                      color: Colors.black
                    )),
              )
            ],
          ),
        ),
      ),
      onTap: this.survey['isFilled']
          ? null
          : () async {
              // ignore: unused_local_variable
              var r = await populateQuestions(this.survey['surveyId']);
              Navigator.push(
                context,
                MaterialPageRoute(
                  builder: (context) => SurveyQuestions(
                      this.survey, this.question, this.questionOptions),
                ),
              ).then((value) => this.populateSurveysList());
            },
    );
  }
}
