import 'package:community_material_icon/community_material_icon.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:intl/intl.dart';

import '../../../theme/variables.dart';

// ignore: must_be_immutable
class TimeQuestion extends StatefulWidget {
  int fieldId;
  Function fillAnswer;

  TimeQuestion(this.fieldId, this.fillAnswer);
  @override
  _TimeQuestionState createState() => _TimeQuestionState();
}

class _TimeQuestionState extends State<TimeQuestion> {
  // ignore: avoid_init_to_null
  TimeOfDay? _selectedTime = null;
  final format = DateFormat.jm();
  //var timeFormat;
  String formatTimeOfDay(TimeOfDay tod) {
    final now = new DateTime.now();
    final dt = DateTime(now.year, now.month, now.day, tod.hour, tod.minute);
    final format = DateFormat.jm(); //"6:00 AM"
    return format.format(dt);
  }

  @override
  Widget build(BuildContext context) {
    void _presentTimePicker() async {
      await showTimePicker(
        context: context,
        initialTime: TimeOfDay.now(),
        initialEntryMode: TimePickerEntryMode.input,
        builder: (context, child) {
          return Theme(
            data: ThemeData.light().copyWith(
              colorScheme: ColorScheme.light().copyWith(
                primary: Variables.color_primary, //Head background
              ),
            ),
            child: child!,
          );
        },
      ).then(
        (value) => {
          setState(
            () {
              if (value != null) {
                _selectedTime = value;
                widget.fillAnswer(
                    this.widget.fieldId, formatTimeOfDay(_selectedTime!));
              }

              //this.timeFormat = DateFormat("HH:mm").format(now);
            },
          ),
        },
      );
    }

    return Container(
      padding: EdgeInsets.only(top: 5),
      child: GestureDetector(
        onTap: () => {
          // if (_selectedTime != null)
          //   {
          _presentTimePicker(),
          // }
        },
        child: Row(
          mainAxisAlignment: MainAxisAlignment.spaceBetween,
          children: <Widget>[
            Container(
              child: Text(
                _selectedTime == null
                    ? 'no-data-found'.tr
                    : formatTimeOfDay(_selectedTime!),
              ),
            ),
            // ignore: deprecated_member_use
            Row(
              children: [
                Text(
                  "select".tr,
                  style: TextStyle(
                      color: Colors.grey, fontWeight: FontWeight.bold),
                ),
                Icon(
                  CommunityMaterialIcons.chevron_down,
                  color: Colors.grey,
                )
              ],
            )
          ],
        ),
      ),
    );
  }
}
