import 'package:flutter/material.dart';
import 'package:flutter_rating_bar/flutter_rating_bar.dart';

// ignore: must_be_immutable
class RateQueston extends StatelessWidget {
  int fieldId;
  Function fillAnswer;

  RateQueston(this.fieldId, this.fillAnswer);

  @override
  Widget build(BuildContext context) {
    return Center(
      child: RatingBar.builder(
        initialRating: 0,
        minRating: 0,
        direction: Axis.horizontal,
        allowHalfRating: false,
        itemCount: 5,
        itemPadding: EdgeInsets.symmetric(horizontal: 4.0),
        itemBuilder: (context, _) => Icon(
          Icons.star,
          color: Colors.amber,
        ),
        onRatingUpdate: (rating) {
          if (rating == 0) {
            this.fillAnswer(this.fieldId, '');
          } else {
            this.fillAnswer(this.fieldId, rating.toString());
          }
        },
      ),
    );
  }
}
