import 'package:community_material_icon/community_material_icon.dart';
import 'package:flutter/material.dart';
import 'package:intl/intl.dart';
import 'package:get/get.dart';

import '../../../theme/variables.dart';

// ignore: must_be_immutable
class DateQuestion extends StatefulWidget {
  int fieldId;
  Function fillAnswer;
  DateQuestion(this.fieldId, this.fillAnswer);
  @override
  _DateQuestionState createState() => _DateQuestionState();
}

class _DateQuestionState extends State<DateQuestion> {
  DateTime? _selectedDate;

  @override
  Widget build(BuildContext context) {
    void _presentDatePicker() {
      showDatePicker(
        context: context,
        initialDate: DateTime.now(),
        firstDate: DateTime(1000),
        lastDate: DateTime(3000),
        builder: (context, child) {
          return Theme(
            data: ThemeData.light().copyWith(
              colorScheme: ColorScheme.light().copyWith(
                primary: Variables.color_primary,
              ),
            ),
            child: child!,
          );
        },
      ).then(
        (pickedDate) => {
          setState(
            () {
              if (pickedDate != null) {
                _selectedDate = pickedDate;
                widget.fillAnswer(widget.fieldId,
                    DateFormat('dd/MM/yyyy').format(_selectedDate!).toString());
              } else {
                widget.fillAnswer(widget.fieldId, '');
              }
            },
          ),
        },
      );
    }

    return Container(
      padding: EdgeInsets.only(top: 5),
      child: GestureDetector(
        onTap: () => _presentDatePicker(),
        child: Row(
          mainAxisAlignment: MainAxisAlignment.spaceBetween,
          children: <Widget>[
            Container(
              child: Text(
                _selectedDate == null
                    ? 'no-data-found'.tr
                    : DateFormat('dd/MM/yyyy').format(_selectedDate!).toString(),
                style: TextStyle(fontSize: Variables.headline2FontSize),
              ),
            ),
            // ignore: deprecated_member_use
            Row(
              children: [
                Text(
                  "select".tr,
                  style: TextStyle(
                      color: Colors.grey,
                      fontWeight: FontWeight.bold,
                      fontSize: Variables.headline2FontSize),
                ),
                Icon(
                  CommunityMaterialIcons.chevron_down,
                  color: Colors.grey,
                  size: Variables.headline2FontSize,
                )
              ],
            )
          ],
        ),
      ),
    );
  }
}
