import 'package:echo_app/shared/core.session.dart';
import 'package:echo_app/theme/variables.dart';
import 'package:flutter/material.dart';

// ignore: must_be_immutable
class TotalBox extends StatelessWidget {
  double netTotal = 0;
  String totalClass = '';
  TotalBox(this.netTotal, this.totalClass);

  @override
  Widget build(BuildContext context) {
    return Container(
      decoration: BoxDecoration(
        border: Border(
          top: BorderSide(color: Colors.grey, width: 1),
        ),
      ),
      child: Row(
        mainAxisAlignment: MainAxisAlignment.center,
        crossAxisAlignment: CrossAxisAlignment.center,
        children: <Widget>[
          Text(
            this
                .netTotal
                .toStringAsFixed(CoreSession.numberOfDigits)
                .toString(),
            style: TextStyle(
                fontSize: Variables.headline1FontSize,
                color: this.totalClass == 'debit' ? Colors.red : Colors.green,
                decoration: TextDecoration.none,
                fontWeight: FontWeight.bold),
          ),
          Text(
            " " + CoreSession.currentOperator['currencyCode'],
            style: TextStyle(
                fontSize: Variables.headline1FontSize,
                color: Colors.black,
                decoration: TextDecoration.none),
          ),
        ],
      ),
    );
  }
}
