import 'package:echo_app/shared/core.session.dart';
import 'package:echo_app/theme/variables.dart';
import 'package:echo_app/widgets/utils.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';

// ignore: must_be_immutable
class SOAReportItem extends StatelessWidget {
  var transaction;
  SOAReportItem(this.transaction);
  @override
  Widget build(BuildContext context) {
    return Card(
      elevation: 2,
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.stretch,
        children: [
          Container(
            color: Variables.color_primary,
            padding: const EdgeInsets.all(5),
            child: Text(
              this.transaction['transactionId'],
              textAlign: TextAlign.center,
              style: TextStyle(fontSize: Variables.headline5FontSize)
                  .apply(color: Colors.white),
            ),
          ),
          Container(
              padding: EdgeInsets.symmetric(vertical: 1),
              color: Colors.grey.shade200,
              child: Text(
                this.transaction['transactionDate'],
                textAlign: TextAlign.center,
                style: TextStyle(fontSize: Variables.headline5FontSize),
              )),
          addVerticalSpace(10),
          Text(
            "original".tr,
            textAlign: TextAlign.center,
            style: TextStyle(fontSize: Variables.headline2FontSize, fontWeight: FontWeight.bold),
          ),
          addVerticalSpace(5),
          Text(
            this
                    .transaction['netTotal']
                    .toStringAsFixed(CoreSession.numberOfDigits) +
                " (" +
                CoreSession.currentOperator['currencyCode'] +
                ")",
            textAlign: TextAlign.center,
            style: TextStyle(
              fontSize: Variables.headline5FontSize,
             
            ),
          ),
          addVerticalSpace(10),
          Text("remaining".tr,
              textAlign: TextAlign.center,
              style: TextStyle(fontSize: Variables.headline2FontSize, fontWeight: FontWeight.bold)),
          addVerticalSpace(5),
          Text(
            this
                    .transaction['remainingAmount']
                    .toStringAsFixed(CoreSession.numberOfDigits) +
                " (" +
                CoreSession.currentOperator['currencyCode'] +
                ")",
            textAlign: TextAlign.center,
            style: TextStyle(
                fontSize: Variables.headline5FontSize,
                fontWeight: FontWeight.bold,
                color: this.transaction['type'] == "Debit"
                    ? Colors.red
                    : Colors.green),
          ),
         // addVerticalSpace(10),
        ],
      ),
    );

    // footer: GridTileBar(
    //   backgroundColor: Colors.black87,
    //   leading: IconButton(
    //     icon: Icon(
    //       Icons.favorite,
    //       color: Theme.of(context).accentColor,
    //     ),
    //     onPressed: () {},
    //   ),
    //   title: Text(
    //     "ddd",
    //     textAlign: TextAlign.center,
    //   ),
    //   trailing: IconButton(
    //     icon: Icon(
    //       Icons.shopping_cart,
    //       color: Theme.of(context).accentColor,
    //     ),
    //     onPressed: () {},
    //   ),
    // ),
  }
}
