import 'package:community_material_icon/community_material_icon.dart';
import 'package:echo_app/theme/variables.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';

import '../../../shared/core.session.dart';

// ignore: must_be_immutable
class FilterPage extends StatefulWidget {
  Function? onClickApply;
  RangeValues _currentRange;
  FilterPage(this.onClickApply,this._currentRange);
  _FilterPage createState() => _FilterPage();
}

class _FilterPage extends State<FilterPage> {


  @override
  Widget build(BuildContext context) {
    return Scaffold(
      bottomSheet: Padding(
        padding: const EdgeInsets.all(8.0),
        child: ElevatedButton(
          onPressed: () {
            this.widget.onClickApply!(this.widget._currentRange);
            Navigator.pop(context);
          },
          child: Row(
            children: [
              Spacer(),
              Text('apply'.tr),
              Spacer(),
            ],
          ),
          style: ElevatedButton.styleFrom(
            backgroundColor: Variables.color_primary,
            shape: RoundedRectangleBorder(
              borderRadius: BorderRadius.circular(10),
            ),
          ),
        ),
      ),
      body: Column(
        children: [
          Padding(
            padding:
                const EdgeInsets.symmetric(horizontal: 10.0, vertical: 0.0),
            child: Container(
              height: 50,
              child: Row(
                children: [

                  Text('filter'.tr, style: Theme.of(context).textTheme.bodyMedium),
                  Spacer(),
                ],
              ),
            ),
          ),
          Expanded(
            flex: 1,
            child: Padding(
              padding: const EdgeInsets.all(8.0),
              child: SingleChildScrollView(
                child: Column(
                  children: [
                    Row(
                      children: [
                        Text("price".tr, style: Theme.of(context).textTheme.bodyMedium),
                      ],
                    ),
                    RangeSlider(
                      values: this.widget._currentRange,
                      min: 0,
                      max: 5000,
                      divisions: 1000,
                      labels: RangeLabels(
                        this.widget._currentRange.start.round().toString(),
                        this.widget._currentRange.end.round().toString(),
                      ),
                      onChanged: (RangeValues values) {
                        setState(() {
                          this.widget._currentRange = values;
                          print(this.widget._currentRange);
                        });
                      },
                    ),
                    ListView(
                        shrinkWrap: true,
                        physics: NeverScrollableScrollPhysics(),
                        padding: EdgeInsets.symmetric(vertical: 8.0, horizontal: 0.0),
                        children: [
                          for (var item in CoreSession.homePageData)
                            Column(
                              children: [
                                Row(
                                  children: [
                                    Text(item['sectionName'].toString(), style: Theme.of(context).textTheme.bodyMedium),
                                  ],
                                ),
                                ListView.builder(
                                  shrinkWrap: true,
                                  physics: const NeverScrollableScrollPhysics(),
                                  itemCount: item['dataList'].length,
                                  itemBuilder: (_, index) {
                                    return CheckboxListTile(
                                      title: Text(item['dataList'][index]['name']),
                                      value: item['dataList'][index]['selected'],
                                      onChanged: (val) {
                                        setState(() {
                                          item['dataList'][index]['selected'] = val;
                                        });
                                      },
                                    );
                                  },
                                ),
                              ],
                            ),
                        ]),
                    SizedBox(height: 50,)
                  ],
                ),
              ),
            ),
          ),

        ],
      ),
    );
  }
}
