import 'package:echo_app/shared/core.session.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';

// ignore: must_be_immutable
class QuantityBox extends StatelessWidget {
  var item;
  bool isFromOrderHistory;
  bool showDeliveredQty;
  QuantityBox(this.item, this.isFromOrderHistory, this.showDeliveredQty);
  @override
  Widget build(BuildContext context) {
    return !this.isFromOrderHistory
        ? Container(
            child: Text(
              this
                  .item['requiredQty']
                  .toStringAsFixed(CoreSession.numberOfStockDigits),
              style: TextStyle(fontWeight: FontWeight.bold),
            ),
          )
        : Column(
            crossAxisAlignment: CrossAxisAlignment.start,
            children: [
              Row(
                children: [
                  Text(
                    "requested".tr + ": ",
                    style: TextStyle(fontWeight: FontWeight.bold, fontSize: 15),
                  ),
                  Text(
                      this
                          .item['requestedQuantity']
                          .toStringAsFixed(CoreSession.numberOfDigits)
                          .toString(),
                      style: TextStyle(fontSize: 15))
                ],
              ),
              if (this.showDeliveredQty)
                Row(
                  children: [
                    Text(
                      "delivered".tr + ": ",
                      style:
                          TextStyle(fontWeight: FontWeight.bold, fontSize: 15),
                    ),
                    Text(
                      this.item['requiredQty'].toString() == 'null' ||
                              this.item['requiredQty'].toString() == ''
                          ? 0
                              .toStringAsFixed(CoreSession.numberOfDigits)
                              .toString()
                          : this.item['requiredQty'].toString(),
                      style: TextStyle(fontSize: 15),
                    )
                  ],
                )
            ],
          );
  }
}
