import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:get/get.dart';

import '../../../theme/variables.dart';

// ignore: must_be_immutable
class TakePromotion extends StatelessWidget {
  TextEditingController quantityController = new TextEditingController();
  Function onOfferCountChange;
  Function onTakeOffer;
  int promotionOptionId;
  TakePromotion(int quantity, this.promotionOptionId, this.onOfferCountChange,
      this.onTakeOffer) {
    this.quantityController.text = quantity.toString();
    quantityController.selection = TextSelection.fromPosition(
        TextPosition(offset: quantityController.text.length));
  }

  @override
  Widget build(BuildContext context) {
    Size size = MediaQuery.of(context).size;
    return Row(
      mainAxisAlignment: MainAxisAlignment.start,
      crossAxisAlignment: CrossAxisAlignment.start,
      children: [
        Expanded(
          child: Container(
            //padding: EdgeInsets.only(bottom: 5),
            child: Row(
              mainAxisAlignment: MainAxisAlignment.center,
              children: <Widget>[
                new Wrap(
                  children: [
                    Container(
                      height: 28,
                      width: 28,
                      decoration: BoxDecoration(
                        borderRadius: BorderRadius.all(Radius.circular(5.0)),
                        color: Colors.grey,
                      ),
                      child: IconButton(
                        padding: EdgeInsets.zero,
                        icon: Icon(
                          Icons.remove,
                          color: Colors.white,
                        ),
                        onPressed: () {
                          onOfferCountChange(this.promotionOptionId, '-1');
                        },
                      ),
                    ),
                    Container(
                      width: size.width >= 576 ? 150 : 50,
                      height: 28,
                      margin: EdgeInsets.symmetric(horizontal: 1),
                      //padding: EdgeInsets.symmetric(horizontal: 5),
                      child: TextField(
                        enableInteractiveSelection: false,
                        keyboardType: TextInputType.number,
                        inputFormatters: <TextInputFormatter>[
                          FilteringTextInputFormatter.digitsOnly
                        ],
                        style: TextStyle(
                          fontSize: 15.0,
                          color: Colors.black,
                          fontWeight: FontWeight.bold,
                        ),
                        textAlign: TextAlign.center,
                        controller: quantityController,
                        // maxLength: 2,
                        // maxLengthEnforced: true,
                        onChanged: (text) {
                          onOfferCountChange(this.promotionOptionId, text);
                        },
                        decoration: new InputDecoration(
                          enabledBorder: OutlineInputBorder(
                            borderSide: BorderSide(
                              color: Colors.white,
                            ),
                          ),
                          border: new OutlineInputBorder(
                            borderSide: new BorderSide(color: Colors.red),
                            borderRadius: const BorderRadius.all(
                              const Radius.circular(0),
                            ),
                          ),
                          focusedBorder: OutlineInputBorder(
                            borderSide: BorderSide(color: Colors.white),
                            borderRadius: const BorderRadius.all(
                              const Radius.circular(0),
                            ),
                          ),
                          filled: true,
                          hintStyle: new TextStyle(color: Colors.grey),
                          hintText: "0",
                          fillColor: Colors.white70,
                          contentPadding: EdgeInsets.symmetric(vertical: 5),
                        ),
                      ),
                    ),
                    Container(
                      height: 28,
                      width: 28,
                      decoration: BoxDecoration(
                          borderRadius: BorderRadius.all(Radius.circular(5.0)),
                          color: Variables.color_primary),
                      child: IconButton(
                        padding: EdgeInsets.zero,
                        icon: Icon(Icons.add),
                        color: Colors.white,
                        onPressed: () {
                          onOfferCountChange(this.promotionOptionId, '1');
                        },
                      ),
                    ),
                  ],
                ),
              ],
            ),
          ),
        ),
        Expanded(
          child: Container(
            height: 30,
            child: ElevatedButton(
              onPressed: () => onTakeOffer(this.promotionOptionId),
              child: Text("take-offer".tr),
              style: ElevatedButton.styleFrom(
                backgroundColor: Variables.color_primary,
              ),
            ),
          ),
        ),
      ],
    );
  }
}
