import 'package:echo_app/widgets/no_data.widget.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';

// ignore: must_be_immutable
class OfferDetailsCard extends StatelessWidget {
  var promotionInputs;
  var promotionOutputs;

  OfferDetailsCard(this.promotionInputs, this.promotionOutputs);

  @override
  Widget build(BuildContext context) {
    return ListView.builder(
        itemBuilder: (ctx, index) {
          return promotionInputs.length > 0 && promotionOutputs.length > 0
              ? Container(
                  margin: EdgeInsets.only(bottom: 5),
                  child: Card(
                    child: Column(
                      children: <Widget>[
                        ListTile(
                          title: Text('should-buy'.tr,
                              style: Theme.of(context).textTheme.bodyLarge),
                          subtitle: Text(
                              toQueryString(
                                promotionInputs[index]
                                    ['promotionOptionDetails'],
                              ),
                              style: Theme.of(context).textTheme.bodySmall),
                        ),
                        ListTile(
                          title: Text('will-get'.tr,
                              style: Theme.of(context).textTheme.bodyLarge),
                          subtitle: Text(
                              toQueryString(
                                promotionOutputs[index]
                                    ['promotionOptionDetails'],
                              ),
                              style: Theme.of(context).textTheme.bodySmall),
                        ),
                      ],
                    ),
                  ),
                )
              : NoDataWidget();
        },
        itemCount: promotionInputs.length);
  }

  toQueryString(obj) {
    var parts = [];
    // tslint:disable-next-line:forin
    for (var property in obj) {
      String? value = property['description'];
      if (value != null && value != '') {
        parts.add(value);
      }
      return parts.join(" & ");
    }
  }
}
