import 'dart:async';
import 'dart:ffi';
import 'dart:io';

import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:google_maps_flutter/google_maps_flutter.dart';
import 'package:place_picker/widgets/place_picker.dart';
import 'package:shared_preferences/shared_preferences.dart';

import '../../shared/core.session.dart';
import 'locationClass.dart';

class MapScreen extends StatelessWidget {
   LatLng pos;
   Function Onselected;
   List<MapLocation> locationList =[];
   MapScreen({super.key, required this.pos , required this.Onselected}){
     loadSavedLocation();
   }

   loadSavedLocation() async{
     SharedPreferences prefs = await SharedPreferences.getInstance();
     final List<String>? listString = prefs.getStringList('AddList');

       if (listString != null) {
          locationList = listString.map((e) {
           final parts = e.split(',');
           return MapLocation( parts[0], parts[1], double.parse(parts[2]), double.parse(parts[3]));
         }).toList();
       }
   }

   Future<void> _saveList() async {
     SharedPreferences prefs = await SharedPreferences.getInstance();
     List<String> listString =  locationList.map((obj) => '${obj.addName},${obj.locName},${obj.lat},${obj.lng}').toList();

     await prefs.setStringList('AddList', listString);
   }
  @override
  Widget build(BuildContext context) {
    // TODO: implement build
    GoogleMapController? mController;
    return         Scaffold(
      resizeToAvoidBottomInset: false, //don't forget this!
      body: Container(
        child:  PlacePicker("AIzaSyCz8GLpL9iluRZbeSwwTglQm7P9JNR0QQI",
          displayLocation: pos,
        ),
      ),
    );
  }
}

