import 'package:flutter/material.dart';
import 'package:get/get.dart';

import '../../../theme/variables.dart';

// ignore: must_be_immutable
class SignInButton extends StatelessWidget {
  final Function login;
  bool loading;
  SignInButton(this.login, this.loading);
  onLogin() {
    this.login();
  }

  @override
  Widget build(BuildContext context) {
    return Align(
      alignment: Alignment.center,
      child: Row(
        children: [
          Expanded(
            child: ElevatedButton(
                style: TextButton.styleFrom(
                  padding: EdgeInsets.only(right: 30, left: 30),
                  alignment: Alignment.centerLeft,
                  backgroundColor: Variables.color_primary,
                  shape: const RoundedRectangleBorder(
                      borderRadius: BorderRadius.all(Radius.circular(50))),
                ),
                onPressed: () {
                  this.onLogin();
                },
                child: Center(
                  child: Text(
                    "login-small".tr,
                    style: TextStyle(
                      color: Colors.white,
                      fontSize: 18,
                    ),
                  ),
                )),
          ),
        ],
      ),
    );
  }
}
