import 'package:echo_app/enums/echo-custome-home-page-types.dart';
import 'package:echo_app/theme/variables.dart';
import 'package:echo_app/widgets/classification_card.widget.dart';
import 'package:flutter/material.dart';

// ignore: must_be_immutable
class TopPartSelection extends StatefulWidget {
  var dataList = [];
  String pathStr = '';
  int index;
  Function onSelectPart;
  TopPartSelection(this.dataList, this.index, this.onSelectPart) {
    if (this.dataList.length > 0 &&
        EchoCustomeHomePageTypes.Brands.index ==
            this.dataList[0]['sectionTypeId']) {
      pathStr = 'brand';
    }

    if (this.dataList.length > 0 &&
        EchoCustomeHomePageTypes.Categories.index ==
            this.dataList[0]['sectionTypeId']) {
      pathStr = 'category';
    }

    if (this.dataList.length > 0 &&
        EchoCustomeHomePageTypes.MasterGroupes.index ==
            this.dataList[0]['sectionTypeId']) {
      pathStr = 'itemGroup';
    }

    if (this.dataList.length > 0 &&
        EchoCustomeHomePageTypes.Special.index ==
            this.dataList[0]['sectionTypeId']) {
      pathStr = 'special';
    }
  }

  @override
  State<TopPartSelection> createState() => _TopPartSelectionState();
}

class _TopPartSelectionState extends State<TopPartSelection> {
  String title = '';
  var tempDataList = [];
  @override
  void initState() {
    setState(() {
      widget.dataList.forEach((element) {
        element['selected'] = false;
        this.tempDataList.add(element);
      });

      //remove from index and insert to index zero
      //temp for no affect in the home page
      this.tempDataList[widget.index]['selected'] = true;
      this.tempDataList.removeAt(widget.index);
      this.tempDataList.insert(0, widget.dataList[widget.index]);
    });
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return Container(
      child: Card(
        child: ListView.builder(
          scrollDirection: Axis.horizontal,
          itemBuilder: (ctx, index) {
            return Container(
              width: Variables.small_card_Width,
              child: ClassificationCardWidget(
                this.tempDataList[index]['id'],
                this.tempDataList[index]['sectionTypeId'],
                this.tempDataList[index]['name'],
                this.tempDataList[index]['selected'],
                (itemIndex) {
                  widget.onSelectPart(this.tempDataList[itemIndex], true);
                },index
              ),
            );
          },
          itemCount: this.tempDataList.length,
        ),
      ),
    );
  }
}
