// ignore_for_file: must_be_immutable

import 'package:echo_app/screens/items_list_page/item_list.page.dart';
import 'package:echo_app/widgets/classification_card.widget.dart';
import 'package:echo_app/widgets/search_bar.dart' as search;
import 'package:flutter/material.dart';

import '../../theme/variables.dart';

class GridClassificationPage extends StatelessWidget {
  var dataList = [];
  var sectionTypeId = -1;
  var name = '';
  GridClassificationPage(this.name, this.dataList, this.sectionTypeId);
  TextEditingController _searchCtrl = new TextEditingController();
  @override
  Widget build(BuildContext context) {
    var size = MediaQuery.of(context).size;
    return Scaffold(
      appBar: AppBar(
         backgroundColor: Variables.color_primary,
        title: Text(this.name),
        automaticallyImplyLeading: false,
        actions: <Widget>[
          IconButton(
            icon: Icon(Icons.close),
            onPressed: () {
              Navigator.pop(context);
            },
          ),
        ],
        bottom: PreferredSize(
          preferredSize: Size(50, 50),
          child: search.Search_Bar.CustomSearchBar(this._searchCtrl, () {},true),
        ),
      ),
      body: GridView.builder(
        padding: const EdgeInsets.all(10.0),
        itemCount: this.dataList.length,
        gridDelegate: SliverGridDelegateWithFixedCrossAxisCount(
            crossAxisCount: size.width >= 768 ? 4 : 3,
            crossAxisSpacing: 10,
            mainAxisSpacing: 10,
            mainAxisExtent: size.width >= 768 ? 250 : 150),
        itemBuilder: (ctx, index) => ClassificationCardWidget(
          this.dataList[index]['id'],
          this.sectionTypeId,
          this.dataList[index]['name'],
          false,
          (itemIndex) {
            Navigator.push(
              context,
              MaterialPageRoute(
                builder: (context) => ItemListPage(this.dataList[itemIndex], index, ''),
              ),
            );
          },index
        ),
      ),
    );
  }
}
