import 'package:flutter/material.dart';

import '../../../theme/variables.dart';

// ignore: must_be_immutable
class DashboardsCardWidget extends StatelessWidget {
  String name = '';
  DashboardsCardWidget(this.name);
  @override
  Widget build(BuildContext context) {
    return Card(
      elevation: 3,
      margin: EdgeInsets.all(5),
      child: Padding(
        padding: EdgeInsets.all(15),
        child: Column(
          crossAxisAlignment: CrossAxisAlignment.center,
          mainAxisAlignment: MainAxisAlignment.center,
          children: <Widget>[
            Icon(
              Icons.pie_chart_sharp,
              color: Variables.color_primary,
              size: 50,
            ),
            Container(
                padding: EdgeInsets.only(top: 10),
                child: Text(
                  this.name == '' ? '---' : this.name,
                  style: Theme.of(context).textTheme.bodyMedium,
                  textAlign: TextAlign.center,
                )),
          ],
        ),
      ),
    );
    
  }
}
