import 'package:echo_app/screens/dashboards/widgets/dashboards_card.widget.dart';
import 'package:echo_app/shared/core.session.dart';
import 'package:echo_app/widgets/no_data.widget.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:url_launcher/url_launcher.dart';

import '../../theme/variables.dart';

// ignore: must_be_immutable
class DashboardsPage extends StatelessWidget {
  var selectedDashboard = {};
  var dashboards = [];
  DashboardsPage() {
    this.populateDashboards(
        CoreSession.currentOperator['operatorCustomers'][0]);
  }
  populateDashboards(user) {
    this.selectedDashboard = CoreSession.Dashboards.firstWhere((op) =>
        op['customerId'] == user['customerId'] &&
        op['outletId'] == user['outletId']);
    // ignore: unnecessary_null_comparison
    if (this.selectedDashboard != null) {
      this.dashboards = this.selectedDashboard['dashboards'];
    }
  }

  @override
  Widget build(BuildContext context) {
    var size = MediaQuery.of(context).size;
    return SafeArea(
      child: Scaffold(
        appBar: AppBar(
           backgroundColor: Variables.color_primary,
          title: Text("my-dashboards".tr),
          automaticallyImplyLeading: false,
          actions: <Widget>[
            IconButton(
              icon: Icon(Icons.close),
              onPressed: () {
                Navigator.pop(context);
              },
            ),
          ],
        ),
        body: Container(
          padding: EdgeInsets.symmetric(horizontal: 5, vertical: 5),
          child: Column(
            children: <Widget>[
              Expanded(
                child: dashboards.length > 0
                    ? GridView.builder(
                        padding: const EdgeInsets.all(10.0),
                        itemCount: this.dashboards.length,
                        gridDelegate: SliverGridDelegateWithFixedCrossAxisCount(
                          crossAxisCount: size.width >= 768 ? 3 : 2,
                          //childAspectRatio: 10,
                          crossAxisSpacing: 10,
                          mainAxisSpacing: 10,
                        ),
                        itemBuilder: (ctx, i) => GestureDetector(
                          child: DashboardsCardWidget(dashboards[i]['name']),
                          onTap: () {
                            final _url = Uri.parse(dashboards[i]['url']);
                            launchUrl(_url, mode: LaunchMode.externalApplication);
                          },
                        ),
                      )
                    : NoDataWidget(),
              )
            ],
          ),
        ),
      ),
    );
  }
}
