import 'package:flutter/material.dart';

// ignore: must_be_immutable
class AddressCard extends StatelessWidget {
  var address;
  bool showSelection;
  AddressCard(this.address, this.showSelection);

  @override
  Widget build(BuildContext context) {
    return Card(
      elevation: 1,
      child: ListTile(
        title: Text(this.address['title'],
            style: Theme.of(context).textTheme.bodyMedium),
        subtitle: Text(this.address['subTitle'],
            style: TextStyle(fontWeight: FontWeight.bold, fontSize: 15)),
        trailing: this.showSelection
            ? Checkbox(
                onChanged: (bool? value) {},
                value: this.address['selected'],
              )
            : Text(''),
      ),
    );
  }
}
