import 'package:echo_app/screens/addresses_list/widgets/address_list.page.dart';
import 'package:flutter/material.dart';

import '../../theme/variables.dart';

// ignore: must_be_immutable
class AddressesListPage extends StatelessWidget {
  bool showSelection;
  AddressesListPage(this.showSelection);
  var addressesList = [
    {'title': 'Home', 'subTitle': 'Grays Haddeain 52', 'selected': true},
    {'title': 'Work', 'subTitle': 'incube amman', 'selected': false},
    {'title': 'Bus staion', 'subTitle': 'Jet', 'selected': false},
    {'title': 'Market', 'subTitle': 'Ararfat Sweet', 'selected': false},
  ];
  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
          backgroundColor: Variables.color_primary,
          title: Text("Select address"),
          automaticallyImplyLeading: false,
          actions: <Widget>[
            IconButton(
              icon: Icon(Icons.add),
              onPressed: () {},
            ),
            IconButton(
              icon: Icon(Icons.close),
              onPressed: () {
                Navigator.pop(context);
              },
            ),
          ]),
      body: AddressesList(addressesList, this.showSelection),
      floatingActionButtonLocation: FloatingActionButtonLocation.endFloat,
      floatingActionButton: FloatingActionButton(
        backgroundColor: Variables.color_primary,
        child: Icon(Icons.check),
        onPressed: () {
          Navigator.of(context).pop();
        },
      ),
    );
  }
}
