import 'package:echo_app/screens/contact_us/contact_us.page.dart';
import 'package:echo_app/screens/dashboards/dashboards.page.dart';
import 'package:echo_app/shared/core.session.dart';
import 'package:echo_app/theme/variables.dart';
import 'package:echo_app/widgets/ICashAdd.dart';
import 'package:echo_app/widgets/checkOutBottom.dart';
import 'package:flutter/material.dart';
import 'package:flutter_easyloading/flutter_easyloading.dart';
import 'package:fluttertoast/fluttertoast.dart';
import 'package:geolocator/geolocator.dart';
import 'package:get/get.dart';
import 'package:google_maps_flutter/google_maps_flutter.dart';
import 'package:shared_preferences/shared_preferences.dart';

import '../../models/constant-storage.dart';
import '../../services/general.service.dart';
import '../../services/login.service.dart';
import '../../widgets/AnimatedToggle.dart';
import '../faq/widget/faqs_list_widget.dart';
import '../gest_user_page/guest_user.page.dart';
import '../html_page/html.page.dart';
import '../login_page/login.page.dart';
import '../map/MapScreen.dart';
import '../notifications/notification.page.dart';
import '../offers/offers.page.dart';
import '../order_history/order_history.page.dart';
import '../profile_page/profile.page.dart';
import '../statment_of_account/soa_report.page.dart';
import '../surveys/surveys.page.dart';
import '../vendors-list/vendors-list.page.dart';

// ignore: must_be_immutable
class SettingAccount extends StatelessWidget {

  SettingAccount();
  LoginService _loginService = new LoginService();
  OrderHistoryPage _orderHistoryPage = new OrderHistoryPage();
  GeneralService _generalService = new GeneralService();
  onSelectedLocation(LatLng location) async {

    var locdesc = await CoreSession.getLocationNameByParm(location);
  }
  logout(context) async {
    CoreSession.logOut();
    await Navigator.pushReplacement(
        context, MaterialPageRoute(builder: (context) => LoginPage()));
  }


  @override
  Widget build(BuildContext context) {
    return Scaffold(
      bottomSheet: Padding(
        padding: const EdgeInsets.symmetric(horizontal: 20.0,vertical: 8.0),
        child: Container(
          width: double.infinity,
          height: 50,
          child: ElevatedButton(
          onPressed: () {
            CoreSession.logOut();
             Navigator.pushReplacement(
                context, MaterialPageRoute(builder: (context) => LoginPage()));
            },
            child: Padding(
              padding: const EdgeInsets.all(8.0),
              child: Text("logout".tr,style: TextStyle(color: Colors.red),),
            ),
            style: ElevatedButton.styleFrom(
              backgroundColor: Color(0xffF2F3F2),
              shape: RoundedRectangleBorder(
                borderRadius: BorderRadius.circular(10),
              ),
            ),
          ),
        ),
      ),
      body: Container(
        child: Column(
          children: [
            Expanded(
              flex: 1,
              child: Padding(
                padding: const EdgeInsets.all(10.0),
                child: Column(
                  children: [
                    ClipRRect(
                      borderRadius: BorderRadius.circular(80.0),
                      child: Image.network(
                        'https://img0cf.b8cdn.com/images/logo/55/2116055_logo_1657097539_n.png',
                        height: 60.0,
                        width: 60.0,
                      ),
                    ),
                    Column(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        Text(CoreSession.currentOperator['name'] == null ? "" : CoreSession.currentOperator['name'],style:  TextStyle(color: Colors.black, fontSize: Variables.headline2FontSize),),
                        Text(CoreSession.currentOperator['code'],style:
                        TextStyle(color: Colors.grey, fontSize: Variables.headline2FontSize),),
                      ],
                    ),
                  ],
                ),
              ),
            ),
            Expanded(
              flex: 4,
              child: SingleChildScrollView(
                child: Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  mainAxisAlignment: MainAxisAlignment.start,
                  children: [
                    Divider(color: Colors.grey,),
                    Padding(
                      padding: const EdgeInsets.all(20.0),
                      child: Column(
                        children: [
                          // InkWell(
                          //   onTap: () async {
                          //     SharedPreferences prefs = await SharedPreferences.getInstance();
                          //     var username = prefs.getString(ConstantStorage.username);
                          //     var password = prefs.getString(ConstantStorage.password);
                          //
                          //     Navigator.push(
                          //       context,
                          //       MaterialPageRoute(builder: (context) =>  VendorsList(username!,password!)),
                          //     );
                          //
                          //   },
                          //   child: Padding(
                          //     padding: const EdgeInsets.all(8.0),
                          //     child: Row(
                          //       children: [
                          //         Icon(Icons.home_work_outlined,size: 25,),
                          //         SizedBox(width: 20,),
                          //         Text("change-org".tr,style:
                          //         TextStyle(color: Colors.black, fontSize: Variables.headline2FontSize),),
                          //
                          //       ],
                          //     ),
                          //   ),
                          // ),

                          // InkWell(
                          //   onTap: () async {
                          //     Navigator.push(
                          //       context,
                          //       MaterialPageRoute(builder: (context) =>  SOAReprot()),
                          //     );
                          //
                          //   },
                          //   child: Padding(
                          //     padding: const EdgeInsets.all(8.0),
                          //     child: Row(
                          //       children: [
                          //         Icon(Icons.document_scanner_outlined,size: 25,),
                          //         SizedBox(width: 20,),
                          //         Text("soa".tr,style:
                          //         TextStyle(color: Colors.black, fontSize: Variables.headline2FontSize),),
                          //
                          //       ],
                          //     ),
                          //   ),
                          // ),
                          // InkWell(
                          //   onTap: () async {
                          //
                          //     EasyLoading.show(status: 'loading'.tr);
                          //     CoreSession.Dashboards = await _generalService.getDashboards();
                          //     EasyLoading.dismiss();
                          //     if (CoreSession.Dashboards.length == 0){
                          //       Fluttertoast.showToast(
                          //           msg: "no-dashboards".tr,
                          //           toastLength: Toast.LENGTH_SHORT,
                          //           gravity: ToastGravity.CENTER,
                          //           timeInSecForIosWeb: 1,
                          //           textColor: Colors.white,
                          //           fontSize: 16.0);
                          //       return;
                          //     }
                          //     Navigator.push(
                          //       context,
                          //       MaterialPageRoute(builder: (context) =>  DashboardsPage()),
                          //     );
                          //
                          //   },
                          //   child: Padding(
                          //     padding: const EdgeInsets.all(8.0),
                          //     child: Row(
                          //       children: [
                          //         Icon(Icons.note_alt_outlined,size: 25,),
                          //         SizedBox(width: 20,),
                          //         Text("my-dashboards".tr,style:
                          //         TextStyle(color: Colors.black, fontSize: Variables.headline2FontSize),),
                          //
                          //       ],
                          //     ),
                          //   ),
                          // ),
                          // InkWell(
                          //   onTap: (){
                          //     Navigator.push(
                          //       context,
                          //       MaterialPageRoute(builder: (context) =>  _orderHistoryPage),
                          //     );
                          //
                          //   },
                          //   child: Padding(
                          //     padding: const EdgeInsets.all(8.0),
                          //     child: Row(
                          //       children: [
                          //         Icon(Icons.shopping_bag_outlined,size: 25,),
                          //         SizedBox(width: 20,),
                          //         Text("orders-history".tr,style:
                          //         TextStyle(color: Colors.black, fontSize: Variables.headline2FontSize),),
                          //
                          //       ],
                          //     ),
                          //   ),
                          // ),
                          InkWell(
                            onTap: (){
                              Navigator.push(
                                context,
                                MaterialPageRoute(builder: (context) =>  ProfilePage()),
                              );
                            },
                            child: Padding(
                              padding: const EdgeInsets.symmetric(horizontal: 8.0),
                              child: Row(
                                children: [
                                  Image.asset(
                                      'assets/imgs/more_icons/profile.png',
                                      height: 50,
                                      width: 50),
                                  SizedBox(width: 20,),
                                  Text("profile".tr,style: TextStyle(color: Colors.black, fontSize: Variables.headline2FontSize),),

                                ],
                              ),
                            ),
                          ),
                          // InkWell(
                          //   onTap: (){
                          //     Navigator.push(
                          //       context,
                          //       MaterialPageRoute(builder: (context) =>  SurveysPage()),
                          //     );
                          //   },
                          //   child: Padding(
                          //     padding: const EdgeInsets.all(8.0),
                          //     child: Row(
                          //       children: [
                          //         Icon(Icons.summarize_rounded,size: 25,),
                          //         SizedBox(width: 20,),
                          //         Text("surveys".tr,style: TextStyle(color: Colors.black, fontSize: Variables.headline2FontSize),),
                          //
                          //       ],
                          //     ),
                          //   ),
                          // ),
                          InkWell(
                            onTap: (){
                              Navigator.push(
                                context,
                                MaterialPageRoute(builder: (context) =>  HTMLPage(2)),
                              );
                            },
                            child: Padding(
                              padding: const EdgeInsets.all(8.0),
                              child: Row(
                                children: [
                                  Image.asset(
                                      'assets/imgs/more_icons/security.png',
                                      height: 50,
                                      width: 50),
                                  Text("privacy-policy".tr,style: TextStyle(color: Colors.black, fontSize: Variables.headline2FontSize),),

                                ],
                              ),
                            ),
                          ),

                          InkWell(
                            onTap: (){
                              Navigator.push(
                                context,
                                MaterialPageRoute(builder: (context) =>  NotificationPage()),
                              );
                            },
                            child: Padding(
                              padding: const EdgeInsets.all(8.0),
                              child: Row(
                                children: [
                                  Image.asset(
                                      'assets/imgs/more_icons/notification.png',
                                      height: 50,
                                    width: 50),
                                  Text("notifications".tr,style: TextStyle(color: Colors.black, fontSize: Variables.headline2FontSize),),

                                ],
                              ),
                            ),
                          ),

                          InkWell(
                            onTap: (){
                              Navigator.push(
                                context,
                                MaterialPageRoute(builder: (context) =>  FAQsListWidget()),
                              );
                            },
                            child: Padding(
                              padding: const EdgeInsets.all(8.0),
                              child: Row(
                                children: [
                                  Image.asset(
                                      'assets/imgs/more_icons/message-question.png',
                                      height: 50,
                                      width: 50),
                                  Text("FAQs".tr,style: TextStyle(color: Colors.black, fontSize: Variables.headline2FontSize),),

                                ],
                              ),
                            ),
                          ),


                          // InkWell(
                          //   onTap: (){
                          //     Navigator.push(
                          //       context,
                          //       MaterialPageRoute(builder: (context) =>  HTMLPage(1)),
                          //     );
                          //   },
                          //   child: Padding(
                          //     padding: const EdgeInsets.all(8.0),
                          //     child: Row(
                          //       children: [
                          //         Icon(Icons.info_outline,size: 25,),
                          //         SizedBox(width: 20,),
                          //         Text("about-us".tr,style: TextStyle(color: Colors.black, fontSize: Variables.headline2FontSize),),
                          //
                          //       ],
                          //     ),
                          //   ),
                          // ),

                          InkWell(
                            onTap: (){
                              Navigator.push(
                                context,
                                MaterialPageRoute(builder: (context) =>  ContactUsPage()),
                              );
                            },
                            child: Padding(
                              padding: const EdgeInsets.all(8.0),
                              child: Row(
                                children: [
                                  Image.asset(
                                      'assets/imgs/more_icons/message-notif.png',
                                      height: 50,
                                      width: 50),
                                  Text("contact-us".tr,style: TextStyle(color: Colors.black, fontSize: Variables.headline2FontSize),),

                                ],
                              ),
                            ),
                          ),

                          InkWell(
                            child: Padding(
                              padding: const EdgeInsets.all(8.0),
                              child: Row(
                                children: [
                                  Image.asset(
                                      'assets/imgs/more_icons/language.png',
                                      height: 50,
                                      width: 50),
                                  Text("language".tr,style: TextStyle(color: Colors.black, fontSize: Variables.headline2FontSize),),
                                  Spacer(),
                                  Expanded(
                                    flex: 2,
                                    child: Directionality(
                                      textDirection: TextDirection.ltr,
                                      child: AnimatedToggle(
                                        values: CoreSession.selectedLanguageId == 1 ? ['english', 'arabic'] : [ 'arabic' , 'english'],
                                        initialPosition: CoreSession.selectedLanguageId == 1 ? true : false,
                                        onToggleCallback: (value) async {
                                          EasyLoading.show(status: 'waiting'.tr);

                                          await _loginService.onChangeLanguageAfterLogin(
                                              context, value + 1);
                                          EasyLoading.dismiss();
                                          print('language changed');
                                        },
                                        buttonColor: Variables.color_primary,
                                        backgroundColor: const Color(0xFFB5C1CC),
                                        textColor: const Color(0xFFFFFFFF),),
                                    ),
                                  ),
                                ],
                              ),
                            ),
                          ),

                        ],
                      ),
                    ),
                    SizedBox(height: 50,)

                  ],
                ),
              ),
            ),
          ],
        ),
      ),
    );
  }
}
